@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A logical database transparent data encryption state.
 * @property id Resource ID.
 * @property name Resource name.
 * @property state Specifies the state of the transparent data encryption.
 * @property type Resource type.
 */
public data class GetTransparentDataEncryptionResult(
    public val id: String,
    public val name: String,
    public val state: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetTransparentDataEncryptionResult):
            GetTransparentDataEncryptionResult = GetTransparentDataEncryptionResult(
            id = javaType.id(),
            name = javaType.name(),
            state = javaType.state(),
            type = javaType.type(),
        )
    }
}
