@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Workload group operations for a data warehouse
 * @property id Resource ID.
 * @property importance The workload group importance level.
 * @property maxResourcePercent The workload group cap percentage resource.
 * @property maxResourcePercentPerRequest The workload group request maximum grant percentage.
 * @property minResourcePercent The workload group minimum percentage resource.
 * @property minResourcePercentPerRequest The workload group request minimum grant percentage.
 * @property name Resource name.
 * @property queryExecutionTimeout The workload group query execution timeout.
 * @property type Resource type.
 */
public data class GetWorkloadGroupResult(
    public val id: String,
    public val importance: String? = null,
    public val maxResourcePercent: Int,
    public val maxResourcePercentPerRequest: Double? = null,
    public val minResourcePercent: Int,
    public val minResourcePercentPerRequest: Double,
    public val name: String,
    public val queryExecutionTimeout: Int? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetWorkloadGroupResult):
            GetWorkloadGroupResult = GetWorkloadGroupResult(
            id = javaType.id(),
            importance = javaType.importance().map({ args0 -> args0 }).orElse(null),
            maxResourcePercent = javaType.maxResourcePercent(),
            maxResourcePercentPerRequest = javaType.maxResourcePercentPerRequest().map({ args0 ->
                args0
            }).orElse(null),
            minResourcePercent = javaType.minResourcePercent(),
            minResourcePercentPerRequest = javaType.minResourcePercentPerRequest(),
            name = javaType.name(),
            queryExecutionTimeout = javaType.queryExecutionTimeout().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
