@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Partner region information for the failover group.
 * @property location Geo location of the partner managed instances.
 * @property replicationRole Replication role of the partner managed instances.
 */
public data class PartnerRegionInfoResponse(
    public val location: String? = null,
    public val replicationRole: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.PartnerRegionInfoResponse):
            PartnerRegionInfoResponse = PartnerRegionInfoResponse(
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            replicationRole = javaType.replicationRole(),
        )
    }
}
