@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains error information for an Azure SQL Database, Server or Elastic Pool Recommended Action.
 * @property errorCode Gets the reason why the recommended action was put to error state. e.g., DatabaseHasQdsOff, IndexAlreadyExists
 * @property isRetryable Gets whether the error could be ignored and recommended action could be retried. Possible values are: Yes/No
 */
public data class RecommendedActionErrorInfoResponse(
    public val errorCode: String,
    public val isRetryable: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.RecommendedActionErrorInfoResponse):
            RecommendedActionErrorInfoResponse = RecommendedActionErrorInfoResponse(
            errorCode = javaType.errorCode(),
            isRetryable = javaType.isRetryable(),
        )
    }
}
