@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A private endpoint connection under a server
 * @property id Resource ID.
 * @property properties Private endpoint connection properties
 */
public data class ServerPrivateEndpointConnectionResponse(
    public val id: String,
    public val properties: PrivateEndpointConnectionPropertiesResponse,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.ServerPrivateEndpointConnectionResponse):
            ServerPrivateEndpointConnectionResponse = ServerPrivateEndpointConnectionResponse(
            id = javaType.id(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.sql.kotlin.outputs.PrivateEndpointConnectionPropertiesResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
