@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * An ARM Resource SKU.
 * @property capacity Capacity of the particular SKU.
 * @property family If the service has different generations of hardware, for the same SKU, then that can be captured here.
 * @property name The name of the SKU, typically, a letter + Number code, e.g. P3.
 * @property size Size of the particular SKU
 * @property tier The tier or edition of the particular SKU, e.g. Basic, Premium.
 */
public data class SkuResponse(
    public val capacity: Int? = null,
    public val family: String? = null,
    public val name: String,
    public val size: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.SkuResponse): SkuResponse =
            SkuResponse(
                capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
                family = javaType.family().map({ args0 -> args0 }).orElse(null),
                name = javaType.name(),
                size = javaType.size().map({ args0 -> args0 }).orElse(null),
                tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
            )
    }
}
