@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of column in sync group table.
 * @property dataSize Data size of the column.
 * @property dataType Data type of the column.
 * @property quotedName Quoted name of sync group table column.
 */
public data class SyncGroupSchemaTableColumnResponse(
    public val dataSize: String? = null,
    public val dataType: String? = null,
    public val quotedName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.SyncGroupSchemaTableColumnResponse):
            SyncGroupSchemaTableColumnResponse = SyncGroupSchemaTableColumnResponse(
            dataSize = javaType.dataSize().map({ args0 -> args0 }).orElse(null),
            dataType = javaType.dataType().map({ args0 -> args0 }).orElse(null),
            quotedName = javaType.quotedName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
