@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of a Vulnerability Assessment recurring scans.
 * @property emailSubscriptionAdmins Specifies that the schedule scan notification will be is sent to the subscription administrators.
 * @property emails Specifies an array of e-mail addresses to which the scan notification is sent.
 * @property isEnabled Recurring scans state.
 */
public data class VulnerabilityAssessmentRecurringScansPropertiesResponse(
    public val emailSubscriptionAdmins: Boolean? = null,
    public val emails: List<String>? = null,
    public val isEnabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.VulnerabilityAssessmentRecurringScansPropertiesResponse):
            VulnerabilityAssessmentRecurringScansPropertiesResponse =
            VulnerabilityAssessmentRecurringScansPropertiesResponse(
                emailSubscriptionAdmins = javaType.emailSubscriptionAdmins().map({ args0 -> args0 }).orElse(null),
                emails = javaType.emails().map({ args0 -> args0 }),
                isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            )
    }
}
