@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin

import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs.builder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.SqlImageSku
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.SqlManagementMode
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.SqlServerLicenseType
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.AssessmentSettingsArgs
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.AssessmentSettingsArgsBuilder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.AutoBackupSettingsArgs
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.AutoBackupSettingsArgsBuilder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.AutoPatchingSettingsArgs
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.AutoPatchingSettingsArgsBuilder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.KeyVaultCredentialSettingsArgs
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.KeyVaultCredentialSettingsArgsBuilder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.ResourceIdentityArgs
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.ResourceIdentityArgsBuilder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.ServerConfigurationsManagementSettingsArgs
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.ServerConfigurationsManagementSettingsArgsBuilder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.StorageConfigurationSettingsArgs
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.StorageConfigurationSettingsArgsBuilder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.WsfcDomainCredentialsArgs
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs.WsfcDomainCredentialsArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A SQL virtual machine.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2017-03-01-preview.
 * Other available API versions: 2023-01-01-preview.
 * ## Example Usage
 * ### Creates or updates a SQL virtual machine and joins it to a SQL virtual machine group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVirtualMachine = new AzureNative.SqlVirtualMachine.SqlVirtualMachine("sqlVirtualMachine", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlVirtualMachineGroupResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/testvmgroup",
 *         SqlVirtualMachineName = "testvm",
 *         VirtualMachineResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm2",
 *         WsfcDomainCredentials = new AzureNative.SqlVirtualMachine.Inputs.WsfcDomainCredentialsArgs
 *         {
 *             ClusterBootstrapAccountPassword = "<Password>",
 *             ClusterOperatorAccountPassword = "<Password>",
 *             SqlServiceAccountPassword = "<Password>",
 *         },
 *         WsfcStaticIp = "10.0.0.7",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewSqlVirtualMachine(ctx, "sqlVirtualMachine", &sqlvirtualmachine.SqlVirtualMachineArgs{
 * 			Location:                         pulumi.String("northeurope"),
 * 			ResourceGroupName:                pulumi.String("testrg"),
 * 			SqlVirtualMachineGroupResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/testvmgroup"),
 * 			SqlVirtualMachineName:            pulumi.String("testvm"),
 * 			VirtualMachineResourceId:         pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm2"),
 * 			WsfcDomainCredentials: &sqlvirtualmachine.WsfcDomainCredentialsArgs{
 * 				ClusterBootstrapAccountPassword: pulumi.String("<Password>"),
 * 				ClusterOperatorAccountPassword:  pulumi.String("<Password>"),
 * 				SqlServiceAccountPassword:       pulumi.String("<Password>"),
 * 			},
 * 			WsfcStaticIp: pulumi.String("10.0.0.7"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVirtualMachine = new SqlVirtualMachine("sqlVirtualMachine", SqlVirtualMachineArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlVirtualMachineGroupResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/testvmgroup")
 *             .sqlVirtualMachineName("testvm")
 *             .virtualMachineResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm2")
 *             .wsfcDomainCredentials(Map.ofEntries(
 *                 Map.entry("clusterBootstrapAccountPassword", "<Password>"),
 *                 Map.entry("clusterOperatorAccountPassword", "<Password>"),
 *                 Map.entry("sqlServiceAccountPassword", "<Password>")
 *             ))
 *             .wsfcStaticIp("10.0.0.7")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a SQL virtual machine for Automated Back up Settings with Weekly and Days of the week to run the back up.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVirtualMachine = new AzureNative.SqlVirtualMachine.SqlVirtualMachine("sqlVirtualMachine", new()
 *     {
 *         AutoBackupSettings = new AzureNative.SqlVirtualMachine.Inputs.AutoBackupSettingsArgs
 *         {
 *             BackupScheduleType = "Manual",
 *             BackupSystemDbs = true,
 *             DaysOfWeek = new[]
 *             {
 *                 "Monday",
 *                 "Friday",
 *             },
 *             Enable = true,
 *             EnableEncryption = true,
 *             FullBackupFrequency = "Weekly",
 *             FullBackupStartTime = 6,
 *             FullBackupWindowHours = 11,
 *             LogBackupFrequency = 10,
 *             Password = "<Password>",
 *             RetentionPeriod = 17,
 *             StorageAccessKey = "<primary storage access key>",
 *             StorageAccountUrl = "https://teststorage.blob.core.windows.net/",
 *             StorageContainerName = "testcontainer",
 *         },
 *         AutoPatchingSettings = new AzureNative.SqlVirtualMachine.Inputs.AutoPatchingSettingsArgs
 *         {
 *             DayOfWeek = AzureNative.SqlVirtualMachine.DayOfWeek.Sunday,
 *             Enable = true,
 *             MaintenanceWindowDuration = 60,
 *             MaintenanceWindowStartingHour = 2,
 *         },
 *         KeyVaultCredentialSettings = new AzureNative.SqlVirtualMachine.Inputs.KeyVaultCredentialSettingsArgs
 *         {
 *             Enable = false,
 *         },
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         ServerConfigurationsManagementSettings = new AzureNative.SqlVirtualMachine.Inputs.ServerConfigurationsManagementSettingsArgs
 *         {
 *             AdditionalFeaturesServerConfigurations = new AzureNative.SqlVirtualMachine.Inputs.AdditionalFeaturesServerConfigurationsArgs
 *             {
 *                 IsRServicesEnabled = false,
 *             },
 *             SqlConnectivityUpdateSettings = new AzureNative.SqlVirtualMachine.Inputs.SqlConnectivityUpdateSettingsArgs
 *             {
 *                 ConnectivityType = "PRIVATE",
 *                 Port = 1433,
 *                 SqlAuthUpdatePassword = "<password>",
 *                 SqlAuthUpdateUserName = "sqllogin",
 *             },
 *             SqlStorageUpdateSettings = new AzureNative.SqlVirtualMachine.Inputs.SqlStorageUpdateSettingsArgs
 *             {
 *                 DiskConfigurationType = "NEW",
 *                 DiskCount = 1,
 *                 StartingDeviceId = 2,
 *             },
 *             SqlWorkloadTypeUpdateSettings = new AzureNative.SqlVirtualMachine.Inputs.SqlWorkloadTypeUpdateSettingsArgs
 *             {
 *                 SqlWorkloadType = "OLTP",
 *             },
 *         },
 *         SqlImageSku = "Enterprise",
 *         SqlManagement = "Full",
 *         SqlServerLicenseType = "PAYG",
 *         SqlVirtualMachineName = "testvm",
 *         VirtualMachineResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewSqlVirtualMachine(ctx, "sqlVirtualMachine", &sqlvirtualmachine.SqlVirtualMachineArgs{
 * 			AutoBackupSettings: &sqlvirtualmachine.AutoBackupSettingsArgs{
 * 				BackupScheduleType: pulumi.String("Manual"),
 * 				BackupSystemDbs:    pulumi.Bool(true),
 * 				DaysOfWeek: pulumi.StringArray{
 * 					pulumi.String("Monday"),
 * 					pulumi.String("Friday"),
 * 				},
 * 				Enable:                pulumi.Bool(true),
 * 				EnableEncryption:      pulumi.Bool(true),
 * 				FullBackupFrequency:   pulumi.String("Weekly"),
 * 				FullBackupStartTime:   pulumi.Int(6),
 * 				FullBackupWindowHours: pulumi.Int(11),
 * 				LogBackupFrequency:    pulumi.Int(10),
 * 				Password:              pulumi.String("<Password>"),
 * 				RetentionPeriod:       pulumi.Int(17),
 * 				StorageAccessKey:      pulumi.String("<primary storage access key>"),
 * 				StorageAccountUrl:     pulumi.String("https://teststorage.blob.core.windows.net/"),
 * 				StorageContainerName:  pulumi.String("testcontainer"),
 * 			},
 * 			AutoPatchingSettings: &sqlvirtualmachine.AutoPatchingSettingsArgs{
 * 				DayOfWeek:                     sqlvirtualmachine.DayOfWeekSunday,
 * 				Enable:                        pulumi.Bool(true),
 * 				MaintenanceWindowDuration:     pulumi.Int(60),
 * 				MaintenanceWindowStartingHour: pulumi.Int(2),
 * 			},
 * 			KeyVaultCredentialSettings: &sqlvirtualmachine.KeyVaultCredentialSettingsArgs{
 * 				Enable: pulumi.Bool(false),
 * 			},
 * 			Location:          pulumi.String("northeurope"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerConfigurationsManagementSettings: sqlvirtualmachine.ServerConfigurationsManagementSettingsResponse{
 * 				AdditionalFeaturesServerConfigurations: &sqlvirtualmachine.AdditionalFeaturesServerConfigurationsArgs{
 * 					IsRServicesEnabled: pulumi.Bool(false),
 * 				},
 * 				SqlConnectivityUpdateSettings: &sqlvirtualmachine.SqlConnectivityUpdateSettingsArgs{
 * 					ConnectivityType:      pulumi.String("PRIVATE"),
 * 					Port:                  pulumi.Int(1433),
 * 					SqlAuthUpdatePassword: pulumi.String("<password>"),
 * 					SqlAuthUpdateUserName: pulumi.String("sqllogin"),
 * 				},
 * 				SqlStorageUpdateSettings: &sqlvirtualmachine.SqlStorageUpdateSettingsArgs{
 * 					DiskConfigurationType: pulumi.String("NEW"),
 * 					DiskCount:             pulumi.Int(1),
 * 					StartingDeviceId:      pulumi.Int(2),
 * 				},
 * 				SqlWorkloadTypeUpdateSettings: &sqlvirtualmachine.SqlWorkloadTypeUpdateSettingsArgs{
 * 					SqlWorkloadType: pulumi.String("OLTP"),
 * 				},
 * 			},
 * 			SqlImageSku:              pulumi.String("Enterprise"),
 * 			SqlManagement:            pulumi.String("Full"),
 * 			SqlServerLicenseType:     pulumi.String("PAYG"),
 * 			SqlVirtualMachineName:    pulumi.String("testvm"),
 * 			VirtualMachineResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVirtualMachine = new SqlVirtualMachine("sqlVirtualMachine", SqlVirtualMachineArgs.builder()
 *             .autoBackupSettings(Map.ofEntries(
 *                 Map.entry("backupScheduleType", "Manual"),
 *                 Map.entry("backupSystemDbs", true),
 *                 Map.entry("daysOfWeek",
 *                     "Monday",
 *                     "Friday"),
 *                 Map.entry("enable", true),
 *                 Map.entry("enableEncryption", true),
 *                 Map.entry("fullBackupFrequency", "Weekly"),
 *                 Map.entry("fullBackupStartTime", 6),
 *                 Map.entry("fullBackupWindowHours", 11),
 *                 Map.entry("logBackupFrequency", 10),
 *                 Map.entry("password", "<Password>"),
 *                 Map.entry("retentionPeriod", 17),
 *                 Map.entry("storageAccessKey", "<primary storage access key>"),
 *                 Map.entry("storageAccountUrl", "https://teststorage.blob.core.windows.net/"),
 *                 Map.entry("storageContainerName", "testcontainer")
 *             ))
 *             .autoPatchingSettings(Map.ofEntries(
 *                 Map.entry("dayOfWeek", "Sunday"),
 *                 Map.entry("enable", true),
 *                 Map.entry("maintenanceWindowDuration", 60),
 *                 Map.entry("maintenanceWindowStartingHour", 2)
 *             ))
 *             .keyVaultCredentialSettings(Map.of("enable", false))
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .serverConfigurationsManagementSettings(Map.ofEntries(
 *                 Map.entry("additionalFeaturesServerConfigurations", Map.of("isRServicesEnabled", false)),
 *                 Map.entry("sqlConnectivityUpdateSettings", Map.ofEntries(
 *                     Map.entry("connectivityType", "PRIVATE"),
 *                     Map.entry("port", 1433),
 *                     Map.entry("sqlAuthUpdatePassword", "<password>"),
 *                     Map.entry("sqlAuthUpdateUserName", "sqllogin")
 *                 )),
 *                 Map.entry("sqlStorageUpdateSettings", Map.ofEntries(
 *                     Map.entry("diskConfigurationType", "NEW"),
 *                     Map.entry("diskCount", 1),
 *                     Map.entry("startingDeviceId", 2)
 *                 )),
 *                 Map.entry("sqlWorkloadTypeUpdateSettings", Map.of("sqlWorkloadType", "OLTP"))
 *             ))
 *             .sqlImageSku("Enterprise")
 *             .sqlManagement("Full")
 *             .sqlServerLicenseType("PAYG")
 *             .sqlVirtualMachineName("testvm")
 *             .virtualMachineResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a SQL virtual machine for Storage Configuration Settings to EXTEND Data, Log or TempDB storage pool.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVirtualMachine = new AzureNative.SqlVirtualMachine.SqlVirtualMachine("sqlVirtualMachine", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlVirtualMachineName = "testvm",
 *         StorageConfigurationSettings = new AzureNative.SqlVirtualMachine.Inputs.StorageConfigurationSettingsArgs
 *         {
 *             DiskConfigurationType = "EXTEND",
 *             SqlDataSettings = new AzureNative.SqlVirtualMachine.Inputs.SQLStorageSettingsArgs
 *             {
 *                 Luns = new[]
 *                 {
 *                     2,
 *                 },
 *             },
 *         },
 *         VirtualMachineResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewSqlVirtualMachine(ctx, "sqlVirtualMachine", &sqlvirtualmachine.SqlVirtualMachineArgs{
 * 			Location:              pulumi.String("northeurope"),
 * 			ResourceGroupName:     pulumi.String("testrg"),
 * 			SqlVirtualMachineName: pulumi.String("testvm"),
 * 			StorageConfigurationSettings: sqlvirtualmachine.StorageConfigurationSettingsResponse{
 * 				DiskConfigurationType: pulumi.String("EXTEND"),
 * 				SqlDataSettings: &sqlvirtualmachine.SQLStorageSettingsArgs{
 * 					Luns: pulumi.IntArray{
 * 						pulumi.Int(2),
 * 					},
 * 				},
 * 			},
 * 			VirtualMachineResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVirtualMachine = new SqlVirtualMachine("sqlVirtualMachine", SqlVirtualMachineArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlVirtualMachineName("testvm")
 *             .storageConfigurationSettings(Map.ofEntries(
 *                 Map.entry("diskConfigurationType", "EXTEND"),
 *                 Map.entry("sqlDataSettings", Map.of("luns", 2))
 *             ))
 *             .virtualMachineResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a SQL virtual machine for Storage Configuration Settings to NEW Data, Log and TempDB storage pool.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVirtualMachine = new AzureNative.SqlVirtualMachine.SqlVirtualMachine("sqlVirtualMachine", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlVirtualMachineName = "testvm",
 *         StorageConfigurationSettings = new AzureNative.SqlVirtualMachine.Inputs.StorageConfigurationSettingsArgs
 *         {
 *             DiskConfigurationType = "NEW",
 *             SqlDataSettings = new AzureNative.SqlVirtualMachine.Inputs.SQLStorageSettingsArgs
 *             {
 *                 DefaultFilePath = "F:\\folderpath\\",
 *                 Luns = new[]
 *                 {
 *                     0,
 *                 },
 *             },
 *             SqlLogSettings = new AzureNative.SqlVirtualMachine.Inputs.SQLStorageSettingsArgs
 *             {
 *                 DefaultFilePath = "G:\\folderpath\\",
 *                 Luns = new[]
 *                 {
 *                     1,
 *                 },
 *             },
 *             SqlSystemDbOnDataDisk = true,
 *             SqlTempDbSettings = new AzureNative.SqlVirtualMachine.Inputs.SQLTempDbSettingsArgs
 *             {
 *                 DataFileCount = 8,
 *                 DataFileSize = 256,
 *                 DataGrowth = 512,
 *                 DefaultFilePath = "D:\\TEMP",
 *                 LogFileSize = 256,
 *                 LogGrowth = 512,
 *             },
 *             StorageWorkloadType = "OLTP",
 *         },
 *         VirtualMachineResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewSqlVirtualMachine(ctx, "sqlVirtualMachine", &sqlvirtualmachine.SqlVirtualMachineArgs{
 * 			Location:              pulumi.String("northeurope"),
 * 			ResourceGroupName:     pulumi.String("testrg"),
 * 			SqlVirtualMachineName: pulumi.String("testvm"),
 * 			StorageConfigurationSettings: sqlvirtualmachine.StorageConfigurationSettingsResponse{
 * 				DiskConfigurationType: pulumi.String("NEW"),
 * 				SqlDataSettings: &sqlvirtualmachine.SQLStorageSettingsArgs{
 * 					DefaultFilePath: pulumi.String("F:\\folderpath\\"),
 * 					Luns: pulumi.IntArray{
 * 						pulumi.Int(0),
 * 					},
 * 				},
 * 				SqlLogSettings: &sqlvirtualmachine.SQLStorageSettingsArgs{
 * 					DefaultFilePath: pulumi.String("G:\\folderpath\\"),
 * 					Luns: pulumi.IntArray{
 * 						pulumi.Int(1),
 * 					},
 * 				},
 * 				SqlSystemDbOnDataDisk: pulumi.Bool(true),
 * 				SqlTempDbSettings: &sqlvirtualmachine.SQLTempDbSettingsArgs{
 * 					DataFileCount:   pulumi.Int(8),
 * 					DataFileSize:    pulumi.Int(256),
 * 					DataGrowth:      pulumi.Int(512),
 * 					DefaultFilePath: pulumi.String("D:\\TEMP"),
 * 					LogFileSize:     pulumi.Int(256),
 * 					LogGrowth:       pulumi.Int(512),
 * 				},
 * 				StorageWorkloadType: pulumi.String("OLTP"),
 * 			},
 * 			VirtualMachineResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVirtualMachine = new SqlVirtualMachine("sqlVirtualMachine", SqlVirtualMachineArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlVirtualMachineName("testvm")
 *             .storageConfigurationSettings(Map.ofEntries(
 *                 Map.entry("diskConfigurationType", "NEW"),
 *                 Map.entry("sqlDataSettings", Map.ofEntries(
 *                     Map.entry("defaultFilePath", "F:\\folderpath\\"),
 *                     Map.entry("luns", 0)
 *                 )),
 *                 Map.entry("sqlLogSettings", Map.ofEntries(
 *                     Map.entry("defaultFilePath", "G:\\folderpath\\"),
 *                     Map.entry("luns", 1)
 *                 )),
 *                 Map.entry("sqlSystemDbOnDataDisk", true),
 *                 Map.entry("sqlTempDbSettings", Map.ofEntries(
 *                     Map.entry("dataFileCount", 8),
 *                     Map.entry("dataFileSize", 256),
 *                     Map.entry("dataGrowth", 512),
 *                     Map.entry("defaultFilePath", "D:\\TEMP"),
 *                     Map.entry("logFileSize", 256),
 *                     Map.entry("logGrowth", 512)
 *                 )),
 *                 Map.entry("storageWorkloadType", "OLTP")
 *             ))
 *             .virtualMachineResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a SQL virtual machine with max parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVirtualMachine = new AzureNative.SqlVirtualMachine.SqlVirtualMachine("sqlVirtualMachine", new()
 *     {
 *         AssessmentSettings = new AzureNative.SqlVirtualMachine.Inputs.AssessmentSettingsArgs
 *         {
 *             Enable = true,
 *             RunImmediately = true,
 *             Schedule = new AzureNative.SqlVirtualMachine.Inputs.ScheduleArgs
 *             {
 *                 DayOfWeek = AzureNative.SqlVirtualMachine.AssessmentDayOfWeek.Sunday,
 *                 Enable = true,
 *                 StartTime = "23:17",
 *                 WeeklyInterval = 1,
 *             },
 *         },
 *         AutoBackupSettings = new AzureNative.SqlVirtualMachine.Inputs.AutoBackupSettingsArgs
 *         {
 *             BackupScheduleType = "Manual",
 *             BackupSystemDbs = true,
 *             Enable = true,
 *             EnableEncryption = true,
 *             FullBackupFrequency = "Daily",
 *             FullBackupStartTime = 6,
 *             FullBackupWindowHours = 11,
 *             LogBackupFrequency = 10,
 *             Password = "<Password>",
 *             RetentionPeriod = 17,
 *             StorageAccessKey = "<primary storage access key>",
 *             StorageAccountUrl = "https://teststorage.blob.core.windows.net/",
 *             StorageContainerName = "testcontainer",
 *         },
 *         AutoPatchingSettings = new AzureNative.SqlVirtualMachine.Inputs.AutoPatchingSettingsArgs
 *         {
 *             DayOfWeek = AzureNative.SqlVirtualMachine.DayOfWeek.Sunday,
 *             Enable = true,
 *             MaintenanceWindowDuration = 60,
 *             MaintenanceWindowStartingHour = 2,
 *         },
 *         KeyVaultCredentialSettings = new AzureNative.SqlVirtualMachine.Inputs.KeyVaultCredentialSettingsArgs
 *         {
 *             Enable = false,
 *         },
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         ServerConfigurationsManagementSettings = new AzureNative.SqlVirtualMachine.Inputs.ServerConfigurationsManagementSettingsArgs
 *         {
 *             AdditionalFeaturesServerConfigurations = new AzureNative.SqlVirtualMachine.Inputs.AdditionalFeaturesServerConfigurationsArgs
 *             {
 *                 IsRServicesEnabled = false,
 *             },
 *             SqlConnectivityUpdateSettings = new AzureNative.SqlVirtualMachine.Inputs.SqlConnectivityUpdateSettingsArgs
 *             {
 *                 ConnectivityType = "PRIVATE",
 *                 Port = 1433,
 *                 SqlAuthUpdatePassword = "<password>",
 *                 SqlAuthUpdateUserName = "sqllogin",
 *             },
 *             SqlInstanceSettings = new AzureNative.SqlVirtualMachine.Inputs.SQLInstanceSettingsArgs
 *             {
 *                 Collation = "SQL_Latin1_General_CP1_CI_AS",
 *                 IsIfiEnabled = true,
 *                 IsLpimEnabled = true,
 *                 IsOptimizeForAdHocWorkloadsEnabled = true,
 *                 MaxDop = 8,
 *                 MaxServerMemoryMB = 128,
 *                 MinServerMemoryMB = 0,
 *             },
 *             SqlStorageUpdateSettings = new AzureNative.SqlVirtualMachine.Inputs.SqlStorageUpdateSettingsArgs
 *             {
 *                 DiskConfigurationType = "NEW",
 *                 DiskCount = 1,
 *                 StartingDeviceId = 2,
 *             },
 *             SqlWorkloadTypeUpdateSettings = new AzureNative.SqlVirtualMachine.Inputs.SqlWorkloadTypeUpdateSettingsArgs
 *             {
 *                 SqlWorkloadType = "OLTP",
 *             },
 *         },
 *         SqlImageSku = "Enterprise",
 *         SqlManagement = "Full",
 *         SqlServerLicenseType = "PAYG",
 *         SqlVirtualMachineName = "testvm",
 *         VirtualMachineResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewSqlVirtualMachine(ctx, "sqlVirtualMachine", &sqlvirtualmachine.SqlVirtualMachineArgs{
 * 			AssessmentSettings: sqlvirtualmachine.AssessmentSettingsResponse{
 * 				Enable:         pulumi.Bool(true),
 * 				RunImmediately: pulumi.Bool(true),
 * 				Schedule: &sqlvirtualmachine.ScheduleArgs{
 * 					DayOfWeek:      sqlvirtualmachine.AssessmentDayOfWeekSunday,
 * 					Enable:         pulumi.Bool(true),
 * 					StartTime:      pulumi.String("23:17"),
 * 					WeeklyInterval: pulumi.Int(1),
 * 				},
 * 			},
 * 			AutoBackupSettings: &sqlvirtualmachine.AutoBackupSettingsArgs{
 * 				BackupScheduleType:    pulumi.String("Manual"),
 * 				BackupSystemDbs:       pulumi.Bool(true),
 * 				Enable:                pulumi.Bool(true),
 * 				EnableEncryption:      pulumi.Bool(true),
 * 				FullBackupFrequency:   pulumi.String("Daily"),
 * 				FullBackupStartTime:   pulumi.Int(6),
 * 				FullBackupWindowHours: pulumi.Int(11),
 * 				LogBackupFrequency:    pulumi.Int(10),
 * 				Password:              pulumi.String("<Password>"),
 * 				RetentionPeriod:       pulumi.Int(17),
 * 				StorageAccessKey:      pulumi.String("<primary storage access key>"),
 * 				StorageAccountUrl:     pulumi.String("https://teststorage.blob.core.windows.net/"),
 * 				StorageContainerName:  pulumi.String("testcontainer"),
 * 			},
 * 			AutoPatchingSettings: &sqlvirtualmachine.AutoPatchingSettingsArgs{
 * 				DayOfWeek:                     sqlvirtualmachine.DayOfWeekSunday,
 * 				Enable:                        pulumi.Bool(true),
 * 				MaintenanceWindowDuration:     pulumi.Int(60),
 * 				MaintenanceWindowStartingHour: pulumi.Int(2),
 * 			},
 * 			KeyVaultCredentialSettings: &sqlvirtualmachine.KeyVaultCredentialSettingsArgs{
 * 				Enable: pulumi.Bool(false),
 * 			},
 * 			Location:          pulumi.String("northeurope"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerConfigurationsManagementSettings: sqlvirtualmachine.ServerConfigurationsManagementSettingsResponse{
 * 				AdditionalFeaturesServerConfigurations: &sqlvirtualmachine.AdditionalFeaturesServerConfigurationsArgs{
 * 					IsRServicesEnabled: pulumi.Bool(false),
 * 				},
 * 				SqlConnectivityUpdateSettings: &sqlvirtualmachine.SqlConnectivityUpdateSettingsArgs{
 * 					ConnectivityType:      pulumi.String("PRIVATE"),
 * 					Port:                  pulumi.Int(1433),
 * 					SqlAuthUpdatePassword: pulumi.String("<password>"),
 * 					SqlAuthUpdateUserName: pulumi.String("sqllogin"),
 * 				},
 * 				SqlInstanceSettings: &sqlvirtualmachine.SQLInstanceSettingsArgs{
 * 					Collation:                          pulumi.String("SQL_Latin1_General_CP1_CI_AS"),
 * 					IsIfiEnabled:                       pulumi.Bool(true),
 * 					IsLpimEnabled:                      pulumi.Bool(true),
 * 					IsOptimizeForAdHocWorkloadsEnabled: pulumi.Bool(true),
 * 					MaxDop:                             pulumi.Int(8),
 * 					MaxServerMemoryMB:                  pulumi.Int(128),
 * 					MinServerMemoryMB:                  pulumi.Int(0),
 * 				},
 * 				SqlStorageUpdateSettings: &sqlvirtualmachine.SqlStorageUpdateSettingsArgs{
 * 					DiskConfigurationType: pulumi.String("NEW"),
 * 					DiskCount:             pulumi.Int(1),
 * 					StartingDeviceId:      pulumi.Int(2),
 * 				},
 * 				SqlWorkloadTypeUpdateSettings: &sqlvirtualmachine.SqlWorkloadTypeUpdateSettingsArgs{
 * 					SqlWorkloadType: pulumi.String("OLTP"),
 * 				},
 * 			},
 * 			SqlImageSku:              pulumi.String("Enterprise"),
 * 			SqlManagement:            pulumi.String("Full"),
 * 			SqlServerLicenseType:     pulumi.String("PAYG"),
 * 			SqlVirtualMachineName:    pulumi.String("testvm"),
 * 			VirtualMachineResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVirtualMachine = new SqlVirtualMachine("sqlVirtualMachine", SqlVirtualMachineArgs.builder()
 *             .assessmentSettings(Map.ofEntries(
 *                 Map.entry("enable", true),
 *                 Map.entry("runImmediately", true),
 *                 Map.entry("schedule", Map.ofEntries(
 *                     Map.entry("dayOfWeek", "Sunday"),
 *                     Map.entry("enable", true),
 *                     Map.entry("startTime", "23:17"),
 *                     Map.entry("weeklyInterval", 1)
 *                 ))
 *             ))
 *             .autoBackupSettings(Map.ofEntries(
 *                 Map.entry("backupScheduleType", "Manual"),
 *                 Map.entry("backupSystemDbs", true),
 *                 Map.entry("enable", true),
 *                 Map.entry("enableEncryption", true),
 *                 Map.entry("fullBackupFrequency", "Daily"),
 *                 Map.entry("fullBackupStartTime", 6),
 *                 Map.entry("fullBackupWindowHours", 11),
 *                 Map.entry("logBackupFrequency", 10),
 *                 Map.entry("password", "<Password>"),
 *                 Map.entry("retentionPeriod", 17),
 *                 Map.entry("storageAccessKey", "<primary storage access key>"),
 *                 Map.entry("storageAccountUrl", "https://teststorage.blob.core.windows.net/"),
 *                 Map.entry("storageContainerName", "testcontainer")
 *             ))
 *             .autoPatchingSettings(Map.ofEntries(
 *                 Map.entry("dayOfWeek", "Sunday"),
 *                 Map.entry("enable", true),
 *                 Map.entry("maintenanceWindowDuration", 60),
 *                 Map.entry("maintenanceWindowStartingHour", 2)
 *             ))
 *             .keyVaultCredentialSettings(Map.of("enable", false))
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .serverConfigurationsManagementSettings(Map.ofEntries(
 *                 Map.entry("additionalFeaturesServerConfigurations", Map.of("isRServicesEnabled", false)),
 *                 Map.entry("sqlConnectivityUpdateSettings", Map.ofEntries(
 *                     Map.entry("connectivityType", "PRIVATE"),
 *                     Map.entry("port", 1433),
 *                     Map.entry("sqlAuthUpdatePassword", "<password>"),
 *                     Map.entry("sqlAuthUpdateUserName", "sqllogin")
 *                 )),
 *                 Map.entry("sqlInstanceSettings", Map.ofEntries(
 *                     Map.entry("collation", "SQL_Latin1_General_CP1_CI_AS"),
 *                     Map.entry("isIfiEnabled", true),
 *                     Map.entry("isLpimEnabled", true),
 *                     Map.entry("isOptimizeForAdHocWorkloadsEnabled", true),
 *                     Map.entry("maxDop", 8),
 *                     Map.entry("maxServerMemoryMB", 128),
 *                     Map.entry("minServerMemoryMB", 0)
 *                 )),
 *                 Map.entry("sqlStorageUpdateSettings", Map.ofEntries(
 *                     Map.entry("diskConfigurationType", "NEW"),
 *                     Map.entry("diskCount", 1),
 *                     Map.entry("startingDeviceId", 2)
 *                 )),
 *                 Map.entry("sqlWorkloadTypeUpdateSettings", Map.of("sqlWorkloadType", "OLTP"))
 *             ))
 *             .sqlImageSku("Enterprise")
 *             .sqlManagement("Full")
 *             .sqlServerLicenseType("PAYG")
 *             .sqlVirtualMachineName("testvm")
 *             .virtualMachineResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates a SQL virtual machine with min parameters.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVirtualMachine = new AzureNative.SqlVirtualMachine.SqlVirtualMachine("sqlVirtualMachine", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlVirtualMachineName = "testvm",
 *         VirtualMachineResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewSqlVirtualMachine(ctx, "sqlVirtualMachine", &sqlvirtualmachine.SqlVirtualMachineArgs{
 * 			Location:                 pulumi.String("northeurope"),
 * 			ResourceGroupName:        pulumi.String("testrg"),
 * 			SqlVirtualMachineName:    pulumi.String("testvm"),
 * 			VirtualMachineResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachine;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVirtualMachine = new SqlVirtualMachine("sqlVirtualMachine", SqlVirtualMachineArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlVirtualMachineName("testvm")
 *             .virtualMachineResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Compute/virtualMachines/testvm")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sqlvirtualmachine:SqlVirtualMachine testvm /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/{sqlVirtualMachineName}
 * ```
 * @property assessmentSettings Assessment Settings.
 * @property autoBackupSettings Auto backup settings for SQL Server.
 * @property autoPatchingSettings Auto patching settings for applying critical security updates to SQL virtual machine.
 * @property identity Azure Active Directory identity of the server.
 * @property keyVaultCredentialSettings Key vault credential settings.
 * @property location Resource location.
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverConfigurationsManagementSettings SQL Server configuration management settings.
 * @property sqlImageOffer SQL image offer. Examples include SQL2016-WS2016, SQL2017-WS2016.
 * @property sqlImageSku SQL Server edition type.
 * @property sqlManagement SQL Server Management type.
 * @property sqlServerLicenseType SQL Server license type.
 * @property sqlVirtualMachineGroupResourceId ARM resource id of the SQL virtual machine group this SQL virtual machine is or will be part of.
 * @property sqlVirtualMachineName Name of the SQL virtual machine.
 * @property storageConfigurationSettings Storage Configuration Settings.
 * @property tags Resource tags.
 * @property virtualMachineResourceId ARM Resource id of underlying virtual machine created from SQL marketplace image.
 * @property wsfcDomainCredentials Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
 * @property wsfcStaticIp Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
 */
public data class SqlVirtualMachineArgs(
    public val assessmentSettings: Output<AssessmentSettingsArgs>? = null,
    public val autoBackupSettings: Output<AutoBackupSettingsArgs>? = null,
    public val autoPatchingSettings: Output<AutoPatchingSettingsArgs>? = null,
    public val identity: Output<ResourceIdentityArgs>? = null,
    public val keyVaultCredentialSettings: Output<KeyVaultCredentialSettingsArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverConfigurationsManagementSettings:
    Output<ServerConfigurationsManagementSettingsArgs>? = null,
    public val sqlImageOffer: Output<String>? = null,
    public val sqlImageSku: Output<Either<String, SqlImageSku>>? = null,
    public val sqlManagement: Output<Either<String, SqlManagementMode>>? = null,
    public val sqlServerLicenseType: Output<Either<String, SqlServerLicenseType>>? = null,
    public val sqlVirtualMachineGroupResourceId: Output<String>? = null,
    public val sqlVirtualMachineName: Output<String>? = null,
    public val storageConfigurationSettings: Output<StorageConfigurationSettingsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val virtualMachineResourceId: Output<String>? = null,
    public val wsfcDomainCredentials: Output<WsfcDomainCredentialsArgs>? = null,
    public val wsfcStaticIp: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs =
        com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineArgs.builder()
            .assessmentSettings(
                assessmentSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .autoBackupSettings(
                autoBackupSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .autoPatchingSettings(
                autoPatchingSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyVaultCredentialSettings(
                keyVaultCredentialSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverConfigurationsManagementSettings(
                serverConfigurationsManagementSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .sqlImageOffer(sqlImageOffer?.applyValue({ args0 -> args0 }))
            .sqlImageSku(
                sqlImageSku?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sqlManagement(
                sqlManagement?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sqlServerLicenseType(
                sqlServerLicenseType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .sqlVirtualMachineGroupResourceId(sqlVirtualMachineGroupResourceId?.applyValue({ args0 -> args0 }))
            .sqlVirtualMachineName(sqlVirtualMachineName?.applyValue({ args0 -> args0 }))
            .storageConfigurationSettings(
                storageConfigurationSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .virtualMachineResourceId(virtualMachineResourceId?.applyValue({ args0 -> args0 }))
            .wsfcDomainCredentials(
                wsfcDomainCredentials?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .wsfcStaticIp(wsfcStaticIp?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlVirtualMachineArgs].
 */
@PulumiTagMarker
public class SqlVirtualMachineArgsBuilder internal constructor() {
    private var assessmentSettings: Output<AssessmentSettingsArgs>? = null

    private var autoBackupSettings: Output<AutoBackupSettingsArgs>? = null

    private var autoPatchingSettings: Output<AutoPatchingSettingsArgs>? = null

    private var identity: Output<ResourceIdentityArgs>? = null

    private var keyVaultCredentialSettings: Output<KeyVaultCredentialSettingsArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverConfigurationsManagementSettings:
        Output<ServerConfigurationsManagementSettingsArgs>? = null

    private var sqlImageOffer: Output<String>? = null

    private var sqlImageSku: Output<Either<String, SqlImageSku>>? = null

    private var sqlManagement: Output<Either<String, SqlManagementMode>>? = null

    private var sqlServerLicenseType: Output<Either<String, SqlServerLicenseType>>? = null

    private var sqlVirtualMachineGroupResourceId: Output<String>? = null

    private var sqlVirtualMachineName: Output<String>? = null

    private var storageConfigurationSettings: Output<StorageConfigurationSettingsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var virtualMachineResourceId: Output<String>? = null

    private var wsfcDomainCredentials: Output<WsfcDomainCredentialsArgs>? = null

    private var wsfcStaticIp: Output<String>? = null

    /**
     * @param value Assessment Settings.
     */
    @JvmName("ppvsixwmybchfmfi")
    public suspend fun assessmentSettings(`value`: Output<AssessmentSettingsArgs>) {
        this.assessmentSettings = value
    }

    /**
     * @param value Auto backup settings for SQL Server.
     */
    @JvmName("jlhiqydbffhnojvq")
    public suspend fun autoBackupSettings(`value`: Output<AutoBackupSettingsArgs>) {
        this.autoBackupSettings = value
    }

    /**
     * @param value Auto patching settings for applying critical security updates to SQL virtual machine.
     */
    @JvmName("rgjjvgbfjdwbydwh")
    public suspend fun autoPatchingSettings(`value`: Output<AutoPatchingSettingsArgs>) {
        this.autoPatchingSettings = value
    }

    /**
     * @param value Azure Active Directory identity of the server.
     */
    @JvmName("bdwkjiddeythpuhv")
    public suspend fun identity(`value`: Output<ResourceIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Key vault credential settings.
     */
    @JvmName("ocyiwokaxofyqsyv")
    public suspend fun keyVaultCredentialSettings(`value`: Output<KeyVaultCredentialSettingsArgs>) {
        this.keyVaultCredentialSettings = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("khosrxglywapavic")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("eccmptilgcuircjr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value SQL Server configuration management settings.
     */
    @JvmName("vrfiyspemnxuxeux")
    public suspend
    fun serverConfigurationsManagementSettings(`value`: Output<ServerConfigurationsManagementSettingsArgs>) {
        this.serverConfigurationsManagementSettings = value
    }

    /**
     * @param value SQL image offer. Examples include SQL2016-WS2016, SQL2017-WS2016.
     */
    @JvmName("aqeeyprdgapvsytl")
    public suspend fun sqlImageOffer(`value`: Output<String>) {
        this.sqlImageOffer = value
    }

    /**
     * @param value SQL Server edition type.
     */
    @JvmName("onefkmeyjbspwnxy")
    public suspend fun sqlImageSku(`value`: Output<Either<String, SqlImageSku>>) {
        this.sqlImageSku = value
    }

    /**
     * @param value SQL Server Management type.
     */
    @JvmName("hwjxsjxpjtylfbjs")
    public suspend fun sqlManagement(`value`: Output<Either<String, SqlManagementMode>>) {
        this.sqlManagement = value
    }

    /**
     * @param value SQL Server license type.
     */
    @JvmName("ireenmimwdquorfl")
    public suspend fun sqlServerLicenseType(`value`: Output<Either<String, SqlServerLicenseType>>) {
        this.sqlServerLicenseType = value
    }

    /**
     * @param value ARM resource id of the SQL virtual machine group this SQL virtual machine is or will be part of.
     */
    @JvmName("uctflbjtfbaealdq")
    public suspend fun sqlVirtualMachineGroupResourceId(`value`: Output<String>) {
        this.sqlVirtualMachineGroupResourceId = value
    }

    /**
     * @param value Name of the SQL virtual machine.
     */
    @JvmName("ecsmcgbbedrwgqbq")
    public suspend fun sqlVirtualMachineName(`value`: Output<String>) {
        this.sqlVirtualMachineName = value
    }

    /**
     * @param value Storage Configuration Settings.
     */
    @JvmName("mnubqefypgawdekf")
    public suspend
    fun storageConfigurationSettings(`value`: Output<StorageConfigurationSettingsArgs>) {
        this.storageConfigurationSettings = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("trhllsxggkpwkprj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ARM Resource id of underlying virtual machine created from SQL marketplace image.
     */
    @JvmName("slxgnibbctvobasx")
    public suspend fun virtualMachineResourceId(`value`: Output<String>) {
        this.virtualMachineResourceId = value
    }

    /**
     * @param value Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
     */
    @JvmName("aisehrlresjnonhh")
    public suspend fun wsfcDomainCredentials(`value`: Output<WsfcDomainCredentialsArgs>) {
        this.wsfcDomainCredentials = value
    }

    /**
     * @param value Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
     */
    @JvmName("mhelcajnuiskbyva")
    public suspend fun wsfcStaticIp(`value`: Output<String>) {
        this.wsfcStaticIp = value
    }

    /**
     * @param value Assessment Settings.
     */
    @JvmName("lwuwrgblqmqffmka")
    public suspend fun assessmentSettings(`value`: AssessmentSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assessmentSettings = mapped
    }

    /**
     * @param argument Assessment Settings.
     */
    @JvmName("sgenhgplvpxkbyxs")
    public suspend
    fun assessmentSettings(argument: suspend AssessmentSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AssessmentSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.assessmentSettings = mapped
    }

    /**
     * @param value Auto backup settings for SQL Server.
     */
    @JvmName("olmqyqqmbesbjdtu")
    public suspend fun autoBackupSettings(`value`: AutoBackupSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoBackupSettings = mapped
    }

    /**
     * @param argument Auto backup settings for SQL Server.
     */
    @JvmName("gqwgqcnhjvffyokt")
    public suspend
    fun autoBackupSettings(argument: suspend AutoBackupSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AutoBackupSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoBackupSettings = mapped
    }

    /**
     * @param value Auto patching settings for applying critical security updates to SQL virtual machine.
     */
    @JvmName("avvhqsvpnritcely")
    public suspend fun autoPatchingSettings(`value`: AutoPatchingSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoPatchingSettings = mapped
    }

    /**
     * @param argument Auto patching settings for applying critical security updates to SQL virtual machine.
     */
    @JvmName("qngbbxhyidkgyxlu")
    public suspend
    fun autoPatchingSettings(argument: suspend AutoPatchingSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = AutoPatchingSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.autoPatchingSettings = mapped
    }

    /**
     * @param value Azure Active Directory identity of the server.
     */
    @JvmName("xbuegbspmvkwilrr")
    public suspend fun identity(`value`: ResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Azure Active Directory identity of the server.
     */
    @JvmName("xfqrxfxwcdayhvne")
    public suspend fun identity(argument: suspend ResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Key vault credential settings.
     */
    @JvmName("wglmogwkbshrndym")
    public suspend fun keyVaultCredentialSettings(`value`: KeyVaultCredentialSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultCredentialSettings = mapped
    }

    /**
     * @param argument Key vault credential settings.
     */
    @JvmName("qytgftufjxmfpnvq")
    public suspend
    fun keyVaultCredentialSettings(argument: suspend KeyVaultCredentialSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultCredentialSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultCredentialSettings = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ofqqyrhtupvbqarj")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("lmoehsfmjyxakyeo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value SQL Server configuration management settings.
     */
    @JvmName("ycmhlwxfiiviaewe")
    public suspend
    fun serverConfigurationsManagementSettings(`value`: ServerConfigurationsManagementSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverConfigurationsManagementSettings = mapped
    }

    /**
     * @param argument SQL Server configuration management settings.
     */
    @JvmName("aaemvgtnstubketb")
    public suspend
    fun serverConfigurationsManagementSettings(argument: suspend ServerConfigurationsManagementSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ServerConfigurationsManagementSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serverConfigurationsManagementSettings = mapped
    }

    /**
     * @param value SQL image offer. Examples include SQL2016-WS2016, SQL2017-WS2016.
     */
    @JvmName("krefpfijbcrftrdx")
    public suspend fun sqlImageOffer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlImageOffer = mapped
    }

    /**
     * @param value SQL Server edition type.
     */
    @JvmName("lumptpwmknjeuoxu")
    public suspend fun sqlImageSku(`value`: Either<String, SqlImageSku>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlImageSku = mapped
    }

    /**
     * @param value SQL Server edition type.
     */
    @JvmName("kfpkfqsstcugxecp")
    public fun sqlImageSku(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SqlImageSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlImageSku = mapped
    }

    /**
     * @param value SQL Server edition type.
     */
    @JvmName("cfarjeoaguikekey")
    public fun sqlImageSku(`value`: SqlImageSku) {
        val toBeMapped = Either.ofRight<String, SqlImageSku>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlImageSku = mapped
    }

    /**
     * @param value SQL Server Management type.
     */
    @JvmName("babxmtprcxuhjxea")
    public suspend fun sqlManagement(`value`: Either<String, SqlManagementMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlManagement = mapped
    }

    /**
     * @param value SQL Server Management type.
     */
    @JvmName("opxhogjdprutubfe")
    public fun sqlManagement(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SqlManagementMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlManagement = mapped
    }

    /**
     * @param value SQL Server Management type.
     */
    @JvmName("ejxxvtpwlbnnyjcj")
    public fun sqlManagement(`value`: SqlManagementMode) {
        val toBeMapped = Either.ofRight<String, SqlManagementMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlManagement = mapped
    }

    /**
     * @param value SQL Server license type.
     */
    @JvmName("tyrunjjuqgewhdrw")
    public suspend fun sqlServerLicenseType(`value`: Either<String, SqlServerLicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlServerLicenseType = mapped
    }

    /**
     * @param value SQL Server license type.
     */
    @JvmName("umrehyiihhfsucud")
    public fun sqlServerLicenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SqlServerLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicenseType = mapped
    }

    /**
     * @param value SQL Server license type.
     */
    @JvmName("xbhljksdfavgcaik")
    public fun sqlServerLicenseType(`value`: SqlServerLicenseType) {
        val toBeMapped = Either.ofRight<String, SqlServerLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlServerLicenseType = mapped
    }

    /**
     * @param value ARM resource id of the SQL virtual machine group this SQL virtual machine is or will be part of.
     */
    @JvmName("flejskgrhhuoljdg")
    public suspend fun sqlVirtualMachineGroupResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlVirtualMachineGroupResourceId = mapped
    }

    /**
     * @param value Name of the SQL virtual machine.
     */
    @JvmName("xadjkablphiasgki")
    public suspend fun sqlVirtualMachineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlVirtualMachineName = mapped
    }

    /**
     * @param value Storage Configuration Settings.
     */
    @JvmName("hwpiornhxpqnjdtx")
    public suspend fun storageConfigurationSettings(`value`: StorageConfigurationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageConfigurationSettings = mapped
    }

    /**
     * @param argument Storage Configuration Settings.
     */
    @JvmName("tqnibvtutjyhrkpw")
    public suspend
    fun storageConfigurationSettings(argument: suspend StorageConfigurationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StorageConfigurationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageConfigurationSettings = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kgwlehnieppnknau")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("iimfyhlnakfvheqy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value ARM Resource id of underlying virtual machine created from SQL marketplace image.
     */
    @JvmName("fbbqnayvbixfvwch")
    public suspend fun virtualMachineResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.virtualMachineResourceId = mapped
    }

    /**
     * @param value Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
     */
    @JvmName("dtechouregwrmlvb")
    public suspend fun wsfcDomainCredentials(`value`: WsfcDomainCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wsfcDomainCredentials = mapped
    }

    /**
     * @param argument Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
     */
    @JvmName("lkytmlkukpxbbdvf")
    public suspend
    fun wsfcDomainCredentials(argument: suspend WsfcDomainCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = WsfcDomainCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.wsfcDomainCredentials = mapped
    }

    /**
     * @param value Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
     */
    @JvmName("phgjaagicwxqdqgr")
    public suspend fun wsfcStaticIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wsfcStaticIp = mapped
    }

    internal fun build(): SqlVirtualMachineArgs = SqlVirtualMachineArgs(
        assessmentSettings = assessmentSettings,
        autoBackupSettings = autoBackupSettings,
        autoPatchingSettings = autoPatchingSettings,
        identity = identity,
        keyVaultCredentialSettings = keyVaultCredentialSettings,
        location = location,
        resourceGroupName = resourceGroupName,
        serverConfigurationsManagementSettings = serverConfigurationsManagementSettings,
        sqlImageOffer = sqlImageOffer,
        sqlImageSku = sqlImageSku,
        sqlManagement = sqlManagement,
        sqlServerLicenseType = sqlServerLicenseType,
        sqlVirtualMachineGroupResourceId = sqlVirtualMachineGroupResourceId,
        sqlVirtualMachineName = sqlVirtualMachineName,
        storageConfigurationSettings = storageConfigurationSettings,
        tags = tags,
        virtualMachineResourceId = virtualMachineResourceId,
        wsfcDomainCredentials = wsfcDomainCredentials,
        wsfcStaticIp = wsfcStaticIp,
    )
}
