@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin

import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.WsfcDomainProfileResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs.WsfcDomainProfileResponse.Companion.toKotlin as wsfcDomainProfileResponseToKotlin

/**
 * Builder for [SqlVirtualMachineGroup].
 */
@PulumiTagMarker
public class SqlVirtualMachineGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SqlVirtualMachineGroupArgs = SqlVirtualMachineGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SqlVirtualMachineGroupArgsBuilder.() -> Unit) {
        val builder = SqlVirtualMachineGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SqlVirtualMachineGroup {
        val builtJavaResource =
            com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineGroup(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SqlVirtualMachineGroup(builtJavaResource)
    }
}

/**
 * A SQL virtual machine group.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2017-03-01-preview.
 * Other available API versions: 2023-01-01-preview.
 * ## Example Usage
 * ### Creates or updates a SQL virtual machine group.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sqlVirtualMachineGroup = new AzureNative.SqlVirtualMachine.SqlVirtualMachineGroup("sqlVirtualMachineGroup", new()
 *     {
 *         Location = "northeurope",
 *         ResourceGroupName = "testrg",
 *         SqlImageOffer = "SQL2016-WS2016",
 *         SqlImageSku = "Enterprise",
 *         SqlVirtualMachineGroupName = "testvmgroup",
 *         Tags =
 *         {
 *             { "mytag", "myval" },
 *         },
 *         WsfcDomainProfile = new AzureNative.SqlVirtualMachine.Inputs.WsfcDomainProfileArgs
 *         {
 *             ClusterBootstrapAccount = "testrpadmin",
 *             ClusterOperatorAccount = "testrp@testdomain.com",
 *             ClusterSubnetType = "MultiSubnet",
 *             DomainFqdn = "testdomain.com",
 *             OuPath = "OU=WSCluster,DC=testdomain,DC=com",
 *             SqlServiceAccount = "sqlservice@testdomain.com",
 *             StorageAccountPrimaryKey = "<primary storage access key>",
 *             StorageAccountUrl = "https://storgact.blob.core.windows.net/",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sqlvirtualmachine/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sqlvirtualmachine.NewSqlVirtualMachineGroup(ctx, "sqlVirtualMachineGroup", &sqlvirtualmachine.SqlVirtualMachineGroupArgs{
 * 			Location:                   pulumi.String("northeurope"),
 * 			ResourceGroupName:          pulumi.String("testrg"),
 * 			SqlImageOffer:              pulumi.String("SQL2016-WS2016"),
 * 			SqlImageSku:                pulumi.String("Enterprise"),
 * 			SqlVirtualMachineGroupName: pulumi.String("testvmgroup"),
 * 			Tags: pulumi.StringMap{
 * 				"mytag": pulumi.String("myval"),
 * 			},
 * 			WsfcDomainProfile: &sqlvirtualmachine.WsfcDomainProfileArgs{
 * 				ClusterBootstrapAccount:  pulumi.String("testrpadmin"),
 * 				ClusterOperatorAccount:   pulumi.String("testrp@testdomain.com"),
 * 				ClusterSubnetType:        pulumi.String("MultiSubnet"),
 * 				DomainFqdn:               pulumi.String("testdomain.com"),
 * 				OuPath:                   pulumi.String("OU=WSCluster,DC=testdomain,DC=com"),
 * 				SqlServiceAccount:        pulumi.String("sqlservice@testdomain.com"),
 * 				StorageAccountPrimaryKey: pulumi.String("<primary storage access key>"),
 * 				StorageAccountUrl:        pulumi.String("https://storgact.blob.core.windows.net/"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineGroup;
 * import com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sqlVirtualMachineGroup = new SqlVirtualMachineGroup("sqlVirtualMachineGroup", SqlVirtualMachineGroupArgs.builder()
 *             .location("northeurope")
 *             .resourceGroupName("testrg")
 *             .sqlImageOffer("SQL2016-WS2016")
 *             .sqlImageSku("Enterprise")
 *             .sqlVirtualMachineGroupName("testvmgroup")
 *             .tags(Map.of("mytag", "myval"))
 *             .wsfcDomainProfile(Map.ofEntries(
 *                 Map.entry("clusterBootstrapAccount", "testrpadmin"),
 *                 Map.entry("clusterOperatorAccount", "testrp@testdomain.com"),
 *                 Map.entry("clusterSubnetType", "MultiSubnet"),
 *                 Map.entry("domainFqdn", "testdomain.com"),
 *                 Map.entry("ouPath", "OU=WSCluster,DC=testdomain,DC=com"),
 *                 Map.entry("sqlServiceAccount", "sqlservice@testdomain.com"),
 *                 Map.entry("storageAccountPrimaryKey", "<primary storage access key>"),
 *                 Map.entry("storageAccountUrl", "https://storgact.blob.core.windows.net/")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sqlvirtualmachine:SqlVirtualMachineGroup testvmgroup /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachineGroups/{sqlVirtualMachineGroupName}
 * ```
 */
public class SqlVirtualMachineGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineGroup,
) : KotlinCustomResource(javaResource, SqlVirtualMachineGroupMapper) {
    /**
     * Cluster type.
     */
    public val clusterConfiguration: Output<String>
        get() = javaResource.clusterConfiguration().applyValue({ args0 -> args0 })

    /**
     * Type of cluster manager: Windows Server Failover Cluster (WSFC), implied by the scale type of the group and the OS type.
     */
    public val clusterManagerType: Output<String>
        get() = javaResource.clusterManagerType().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Provisioning state to track the async operation status.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Scale type.
     */
    public val scaleType: Output<String>
        get() = javaResource.scaleType().applyValue({ args0 -> args0 })

    /**
     * SQL image offer. Examples may include SQL2016-WS2016, SQL2017-WS2016.
     */
    public val sqlImageOffer: Output<String>?
        get() = javaResource.sqlImageOffer().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SQL image sku.
     */
    public val sqlImageSku: Output<String>?
        get() = javaResource.sqlImageSku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Cluster Active Directory domain profile.
     */
    public val wsfcDomainProfile: Output<WsfcDomainProfileResponse>?
        get() = javaResource.wsfcDomainProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> wsfcDomainProfileResponseToKotlin(args0) })
            }).orElse(null)
        })
}

public object SqlVirtualMachineGroupMapper : ResourceMapper<SqlVirtualMachineGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineGroup::class == javaResource::class

    override fun map(javaResource: Resource): SqlVirtualMachineGroup =
        SqlVirtualMachineGroup(
            javaResource as
                com.pulumi.azurenative.sqlvirtualmachine.SqlVirtualMachineGroup,
        )
}

/**
 * @see [SqlVirtualMachineGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SqlVirtualMachineGroup].
 */
public suspend fun sqlVirtualMachineGroup(
    name: String,
    block: suspend SqlVirtualMachineGroupResourceBuilder.() -> Unit,
): SqlVirtualMachineGroup {
    val builder = SqlVirtualMachineGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SqlVirtualMachineGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sqlVirtualMachineGroup(name: String): SqlVirtualMachineGroup {
    val builder = SqlVirtualMachineGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
