@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.AgReplicaArgs.builder
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.Commit
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.Failover
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.ReadableSecondary
import com.pulumi.azurenative.sqlvirtualmachine.kotlin.enums.Role
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Availability group replica configuration.
 * @property commit Replica commit mode in availability group.
 * @property failover Replica failover mode in availability group.
 * @property readableSecondary Replica readable secondary mode in availability group.
 * @property role Replica Role in availability group.
 * @property sqlVirtualMachineInstanceId Sql VirtualMachine Instance Id.
 */
public data class AgReplicaArgs(
    public val commit: Output<Either<String, Commit>>? = null,
    public val failover: Output<Either<String, Failover>>? = null,
    public val readableSecondary: Output<Either<String, ReadableSecondary>>? = null,
    public val role: Output<Either<String, Role>>? = null,
    public val sqlVirtualMachineInstanceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.AgReplicaArgs> {
    override fun toJava(): com.pulumi.azurenative.sqlvirtualmachine.inputs.AgReplicaArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.AgReplicaArgs.builder()
            .commit(
                commit?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .failover(
                failover?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .readableSecondary(
                readableSecondary?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .role(
                role?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sqlVirtualMachineInstanceId(sqlVirtualMachineInstanceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AgReplicaArgs].
 */
@PulumiTagMarker
public class AgReplicaArgsBuilder internal constructor() {
    private var commit: Output<Either<String, Commit>>? = null

    private var failover: Output<Either<String, Failover>>? = null

    private var readableSecondary: Output<Either<String, ReadableSecondary>>? = null

    private var role: Output<Either<String, Role>>? = null

    private var sqlVirtualMachineInstanceId: Output<String>? = null

    /**
     * @param value Replica commit mode in availability group.
     */
    @JvmName("fuaawtdfgmvwibrn")
    public suspend fun commit(`value`: Output<Either<String, Commit>>) {
        this.commit = value
    }

    /**
     * @param value Replica failover mode in availability group.
     */
    @JvmName("mvoiqorfkaxitvae")
    public suspend fun failover(`value`: Output<Either<String, Failover>>) {
        this.failover = value
    }

    /**
     * @param value Replica readable secondary mode in availability group.
     */
    @JvmName("psginwyspclpcuxc")
    public suspend fun readableSecondary(`value`: Output<Either<String, ReadableSecondary>>) {
        this.readableSecondary = value
    }

    /**
     * @param value Replica Role in availability group.
     */
    @JvmName("hrphexyfhxhmgqsd")
    public suspend fun role(`value`: Output<Either<String, Role>>) {
        this.role = value
    }

    /**
     * @param value Sql VirtualMachine Instance Id.
     */
    @JvmName("enuyvuyanrsjtoum")
    public suspend fun sqlVirtualMachineInstanceId(`value`: Output<String>) {
        this.sqlVirtualMachineInstanceId = value
    }

    /**
     * @param value Replica commit mode in availability group.
     */
    @JvmName("rmjlboydjnxmiqco")
    public suspend fun commit(`value`: Either<String, Commit>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commit = mapped
    }

    /**
     * @param value Replica commit mode in availability group.
     */
    @JvmName("esprhegxmuevkfvm")
    public fun commit(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Commit>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commit = mapped
    }

    /**
     * @param value Replica commit mode in availability group.
     */
    @JvmName("dcuhsqfxpcdtacru")
    public fun commit(`value`: Commit) {
        val toBeMapped = Either.ofRight<String, Commit>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commit = mapped
    }

    /**
     * @param value Replica failover mode in availability group.
     */
    @JvmName("onodhkwvkxnpkrtl")
    public suspend fun failover(`value`: Either<String, Failover>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failover = mapped
    }

    /**
     * @param value Replica failover mode in availability group.
     */
    @JvmName("vjxontibretwfesf")
    public fun failover(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Failover>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failover = mapped
    }

    /**
     * @param value Replica failover mode in availability group.
     */
    @JvmName("ltmkujlpehgcisnu")
    public fun failover(`value`: Failover) {
        val toBeMapped = Either.ofRight<String, Failover>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failover = mapped
    }

    /**
     * @param value Replica readable secondary mode in availability group.
     */
    @JvmName("orrmlxehusmxshvf")
    public suspend fun readableSecondary(`value`: Either<String, ReadableSecondary>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readableSecondary = mapped
    }

    /**
     * @param value Replica readable secondary mode in availability group.
     */
    @JvmName("rvfgmbtogtwuxwom")
    public fun readableSecondary(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ReadableSecondary>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.readableSecondary = mapped
    }

    /**
     * @param value Replica readable secondary mode in availability group.
     */
    @JvmName("xqyctrohlyfltsin")
    public fun readableSecondary(`value`: ReadableSecondary) {
        val toBeMapped = Either.ofRight<String, ReadableSecondary>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.readableSecondary = mapped
    }

    /**
     * @param value Replica Role in availability group.
     */
    @JvmName("mockvhwmwqunrnxp")
    public suspend fun role(`value`: Either<String, Role>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Replica Role in availability group.
     */
    @JvmName("wtmisiuealxtctrc")
    public fun role(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Role>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Replica Role in availability group.
     */
    @JvmName("trbkicculgrthdtf")
    public fun role(`value`: Role) {
        val toBeMapped = Either.ofRight<String, Role>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.role = mapped
    }

    /**
     * @param value Sql VirtualMachine Instance Id.
     */
    @JvmName("kdbcoqtbvreoeyjx")
    public suspend fun sqlVirtualMachineInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sqlVirtualMachineInstanceId = mapped
    }

    internal fun build(): AgReplicaArgs = AgReplicaArgs(
        commit = commit,
        failover = failover,
        readableSecondary = readableSecondary,
        role = role,
        sqlVirtualMachineInstanceId = sqlVirtualMachineInstanceId,
    )
}
