@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.inputs

import com.pulumi.azurenative.sqlvirtualmachine.inputs.GetSqlVirtualMachinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand The child resources to include in the response.
 * @property resourceGroupName Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sqlVirtualMachineName Name of the SQL virtual machine.
 */
public data class GetSqlVirtualMachinePlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val sqlVirtualMachineName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sqlvirtualmachine.inputs.GetSqlVirtualMachinePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.sqlvirtualmachine.inputs.GetSqlVirtualMachinePlainArgs =
        com.pulumi.azurenative.sqlvirtualmachine.inputs.GetSqlVirtualMachinePlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .sqlVirtualMachineName(sqlVirtualMachineName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSqlVirtualMachinePlainArgs].
 */
@PulumiTagMarker
public class GetSqlVirtualMachinePlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var sqlVirtualMachineName: String? = null

    /**
     * @param value The child resources to include in the response.
     */
    @JvmName("mhwblvvnmanljpmh")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value Name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ofmfextodlxnsvfi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the SQL virtual machine.
     */
    @JvmName("grwekashonnythbm")
    public suspend fun sqlVirtualMachineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.sqlVirtualMachineName = mapped
    }

    internal fun build(): GetSqlVirtualMachinePlainArgs = GetSqlVirtualMachinePlainArgs(
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        sqlVirtualMachineName = sqlVirtualMachineName ?: throw
            PulumiNullFieldException("sqlVirtualMachineName"),
    )
}
