@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Set a patching window during which Windows and SQL patches will be applied.
 * @property dayOfWeek Day of week to apply the patch on.
 * @property enable Enable or disable autopatching on SQL virtual machine.
 * @property maintenanceWindowDuration Duration of patching.
 * @property maintenanceWindowStartingHour Hour of the day when patching is initiated. Local VM time.
 */
public data class AutoPatchingSettingsResponse(
    public val dayOfWeek: String? = null,
    public val enable: Boolean? = null,
    public val maintenanceWindowDuration: Int? = null,
    public val maintenanceWindowStartingHour: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.AutoPatchingSettingsResponse):
            AutoPatchingSettingsResponse = AutoPatchingSettingsResponse(
            dayOfWeek = javaType.dayOfWeek().map({ args0 -> args0 }).orElse(null),
            enable = javaType.enable().map({ args0 -> args0 }).orElse(null),
            maintenanceWindowDuration = javaType.maintenanceWindowDuration().map({ args0 ->
                args0
            }).orElse(null),
            maintenanceWindowStartingHour = javaType.maintenanceWindowStartingHour().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
