@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sqlvirtualmachine.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
 * @property clusterBootstrapAccountPassword Cluster bootstrap account password.
 * @property clusterOperatorAccountPassword Cluster operator account password.
 * @property sqlServiceAccountPassword SQL service account password.
 */
public data class WsfcDomainCredentialsResponse(
    public val clusterBootstrapAccountPassword: String? = null,
    public val clusterOperatorAccountPassword: String? = null,
    public val sqlServiceAccountPassword: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sqlvirtualmachine.outputs.WsfcDomainCredentialsResponse):
            WsfcDomainCredentialsResponse = WsfcDomainCredentialsResponse(
            clusterBootstrapAccountPassword = javaType.clusterBootstrapAccountPassword().map({ args0 ->
                args0
            }).orElse(null),
            clusterOperatorAccountPassword = javaType.clusterOperatorAccountPassword().map({ args0 ->
                args0
            }).orElse(null),
            sqlServiceAccountPassword = javaType.sqlServiceAccountPassword().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
