@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin

import com.pulumi.azurenative.standbypool.kotlin.outputs.ContainerGroupPropertiesResponse
import com.pulumi.azurenative.standbypool.kotlin.outputs.StandbyContainerGroupPoolElasticityProfileResponse
import com.pulumi.azurenative.standbypool.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.standbypool.kotlin.outputs.ContainerGroupPropertiesResponse.Companion.toKotlin as containerGroupPropertiesResponseToKotlin
import com.pulumi.azurenative.standbypool.kotlin.outputs.StandbyContainerGroupPoolElasticityProfileResponse.Companion.toKotlin as standbyContainerGroupPoolElasticityProfileResponseToKotlin
import com.pulumi.azurenative.standbypool.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [StandbyContainerGroupPool].
 */
@PulumiTagMarker
public class StandbyContainerGroupPoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StandbyContainerGroupPoolArgs = StandbyContainerGroupPoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StandbyContainerGroupPoolArgsBuilder.() -> Unit) {
        val builder = StandbyContainerGroupPoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StandbyContainerGroupPool {
        val builtJavaResource =
            com.pulumi.azurenative.standbypool.StandbyContainerGroupPool(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StandbyContainerGroupPool(builtJavaResource)
    }
}

/**
 * A StandbyContainerGroupPoolResource.
 * Azure REST API version: 2023-12-01-preview.
 * ## Example Usage
 * ### StandbyContainerGroupPools_CreateOrUpdate - generated by [MaximumSet] rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var standbyContainerGroupPool = new AzureNative.StandbyPool.StandbyContainerGroupPool("standbyContainerGroupPool", new()
 *     {
 *         ContainerGroupProperties = new AzureNative.StandbyPool.Inputs.ContainerGroupPropertiesArgs
 *         {
 *             ContainerGroupProfile = new AzureNative.StandbyPool.Inputs.ContainerGroupProfileArgs
 *             {
 *                 Id = "/subscriptions/8CC31D61-82D7-4B2B-B9DC-6B924DE7D229/resourceGroups/rgstandbypool/providers/Microsoft.ContainerInstance/containerGroupProfiles/cgProfile",
 *                 Revision = 1,
 *             },
 *             SubnetIds = new[]
 *             {
 *                 new AzureNative.StandbyPool.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/8cf6c1b6-c80f-437c-87ad-45fbaff54f73/resourceGroups/rgstandbypool/providers/Microsoft.Network/virtualNetworks/cgSubnet/subnets/cgSubnet",
 *                 },
 *             },
 *         },
 *         ElasticityProfile = new AzureNative.StandbyPool.Inputs.StandbyContainerGroupPoolElasticityProfileArgs
 *         {
 *             MaxReadyCapacity = 688,
 *             RefillPolicy = "always",
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "rgstandbypool",
 *         StandbyContainerGroupPoolName = "pool",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/standbypool/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := standbypool.NewStandbyContainerGroupPool(ctx, "standbyContainerGroupPool", &standbypool.StandbyContainerGroupPoolArgs{
 * 			ContainerGroupProperties: standbypool.ContainerGroupPropertiesResponse{
 * 				ContainerGroupProfile: &standbypool.ContainerGroupProfileArgs{
 * 					Id:       pulumi.String("/subscriptions/8CC31D61-82D7-4B2B-B9DC-6B924DE7D229/resourceGroups/rgstandbypool/providers/Microsoft.ContainerInstance/containerGroupProfiles/cgProfile"),
 * 					Revision: pulumi.Float64(1),
 * 				},
 * 				SubnetIds: standbypool.SubnetArray{
 * 					&standbypool.SubnetArgs{
 * 						Id: pulumi.String("/subscriptions/8cf6c1b6-c80f-437c-87ad-45fbaff54f73/resourceGroups/rgstandbypool/providers/Microsoft.Network/virtualNetworks/cgSubnet/subnets/cgSubnet"),
 * 					},
 * 				},
 * 			},
 * 			ElasticityProfile: &standbypool.StandbyContainerGroupPoolElasticityProfileArgs{
 * 				MaxReadyCapacity: pulumi.Float64(688),
 * 				RefillPolicy:     pulumi.String("always"),
 * 			},
 * 			Location:                      pulumi.String("West US"),
 * 			ResourceGroupName:             pulumi.String("rgstandbypool"),
 * 			StandbyContainerGroupPoolName: pulumi.String("pool"),
 * 			Tags:                          nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.standbypool.StandbyContainerGroupPool;
 * import com.pulumi.azurenative.standbypool.StandbyContainerGroupPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var standbyContainerGroupPool = new StandbyContainerGroupPool("standbyContainerGroupPool", StandbyContainerGroupPoolArgs.builder()
 *             .containerGroupProperties(Map.ofEntries(
 *                 Map.entry("containerGroupProfile", Map.ofEntries(
 *                     Map.entry("id", "/subscriptions/8CC31D61-82D7-4B2B-B9DC-6B924DE7D229/resourceGroups/rgstandbypool/providers/Microsoft.ContainerInstance/containerGroupProfiles/cgProfile"),
 *                     Map.entry("revision", 1)
 *                 )),
 *                 Map.entry("subnetIds", Map.of("id", "/subscriptions/8cf6c1b6-c80f-437c-87ad-45fbaff54f73/resourceGroups/rgstandbypool/providers/Microsoft.Network/virtualNetworks/cgSubnet/subnets/cgSubnet"))
 *             ))
 *             .elasticityProfile(Map.ofEntries(
 *                 Map.entry("maxReadyCapacity", 688),
 *                 Map.entry("refillPolicy", "always")
 *             ))
 *             .location("West US")
 *             .resourceGroupName("rgstandbypool")
 *             .standbyContainerGroupPoolName("pool")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### StandbyContainerGroupPools_CreateOrUpdate - generated by [MinimumSet] rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var standbyContainerGroupPool = new AzureNative.StandbyPool.StandbyContainerGroupPool("standbyContainerGroupPool", new()
 *     {
 *         Location = "West US",
 *         ResourceGroupName = "rgstandbypool",
 *         StandbyContainerGroupPoolName = "pool",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/standbypool/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := standbypool.NewStandbyContainerGroupPool(ctx, "standbyContainerGroupPool", &standbypool.StandbyContainerGroupPoolArgs{
 * 			Location:                      pulumi.String("West US"),
 * 			ResourceGroupName:             pulumi.String("rgstandbypool"),
 * 			StandbyContainerGroupPoolName: pulumi.String("pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.standbypool.StandbyContainerGroupPool;
 * import com.pulumi.azurenative.standbypool.StandbyContainerGroupPoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var standbyContainerGroupPool = new StandbyContainerGroupPool("standbyContainerGroupPool", StandbyContainerGroupPoolArgs.builder()
 *             .location("West US")
 *             .resourceGroupName("rgstandbypool")
 *             .standbyContainerGroupPoolName("pool")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:standbypool:StandbyContainerGroupPool hi /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyContainerGroupPools/{standbyContainerGroupPoolName}
 * ```
 */
public class StandbyContainerGroupPool internal constructor(
    override val javaResource: com.pulumi.azurenative.standbypool.StandbyContainerGroupPool,
) : KotlinCustomResource(javaResource, StandbyContainerGroupPoolMapper) {
    /**
     * Specifies container group properties of standby container group pools.
     */
    public val containerGroupProperties: Output<ContainerGroupPropertiesResponse>
        get() = javaResource.containerGroupProperties().applyValue({ args0 ->
            args0.let({ args0 ->
                containerGroupPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Specifies elasticity profile of standby container group pools.
     */
    public val elasticityProfile: Output<StandbyContainerGroupPoolElasticityProfileResponse>
        get() = javaResource.elasticityProfile().applyValue({ args0 ->
            args0.let({ args0 ->
                standbyContainerGroupPoolElasticityProfileResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StandbyContainerGroupPoolMapper : ResourceMapper<StandbyContainerGroupPool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.standbypool.StandbyContainerGroupPool::class == javaResource::class

    override fun map(javaResource: Resource): StandbyContainerGroupPool =
        StandbyContainerGroupPool(
            javaResource as
                com.pulumi.azurenative.standbypool.StandbyContainerGroupPool,
        )
}

/**
 * @see [StandbyContainerGroupPool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StandbyContainerGroupPool].
 */
public suspend fun standbyContainerGroupPool(
    name: String,
    block: suspend StandbyContainerGroupPoolResourceBuilder.() -> Unit,
): StandbyContainerGroupPool {
    val builder = StandbyContainerGroupPoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StandbyContainerGroupPool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun standbyContainerGroupPool(name: String): StandbyContainerGroupPool {
    val builder = StandbyContainerGroupPoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
