@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin

import com.pulumi.azurenative.standbypool.kotlin.outputs.StandbyVirtualMachinePoolElasticityProfileResponse
import com.pulumi.azurenative.standbypool.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.standbypool.kotlin.outputs.StandbyVirtualMachinePoolElasticityProfileResponse.Companion.toKotlin as standbyVirtualMachinePoolElasticityProfileResponseToKotlin
import com.pulumi.azurenative.standbypool.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [StandbyVirtualMachinePool].
 */
@PulumiTagMarker
public class StandbyVirtualMachinePoolResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StandbyVirtualMachinePoolArgs = StandbyVirtualMachinePoolArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StandbyVirtualMachinePoolArgsBuilder.() -> Unit) {
        val builder = StandbyVirtualMachinePoolArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): StandbyVirtualMachinePool {
        val builtJavaResource =
            com.pulumi.azurenative.standbypool.StandbyVirtualMachinePool(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return StandbyVirtualMachinePool(builtJavaResource)
    }
}

/**
 * A StandbyVirtualMachinePoolResource.
 * Azure REST API version: 2023-12-01-preview.
 * ## Example Usage
 * ### StandbyVirtualMachinePools_CreateOrUpdate - generated by [MaximumSet] rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var standbyVirtualMachinePool = new AzureNative.StandbyPool.StandbyVirtualMachinePool("standbyVirtualMachinePool", new()
 *     {
 *         AttachedVirtualMachineScaleSetId = "/subscriptions/8CC31D61-82D7-4B2B-B9DC-6B924DE7D229/resourceGroups/vmssRg/providers/Microsoft.Compute/virtualMachineScaleSets/myVmss",
 *         ElasticityProfile = new AzureNative.StandbyPool.Inputs.StandbyVirtualMachinePoolElasticityProfileArgs
 *         {
 *             MaxReadyCapacity = 304,
 *         },
 *         Location = "West US",
 *         ResourceGroupName = "rgstandbypool",
 *         StandbyVirtualMachinePoolName = "pool",
 *         Tags = null,
 *         VirtualMachineState = "Running",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/standbypool/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := standbypool.NewStandbyVirtualMachinePool(ctx, "standbyVirtualMachinePool", &standbypool.StandbyVirtualMachinePoolArgs{
 * 			AttachedVirtualMachineScaleSetId: pulumi.String("/subscriptions/8CC31D61-82D7-4B2B-B9DC-6B924DE7D229/resourceGroups/vmssRg/providers/Microsoft.Compute/virtualMachineScaleSets/myVmss"),
 * 			ElasticityProfile: &standbypool.StandbyVirtualMachinePoolElasticityProfileArgs{
 * 				MaxReadyCapacity: pulumi.Float64(304),
 * 			},
 * 			Location:                      pulumi.String("West US"),
 * 			ResourceGroupName:             pulumi.String("rgstandbypool"),
 * 			StandbyVirtualMachinePoolName: pulumi.String("pool"),
 * 			Tags:                          nil,
 * 			VirtualMachineState:           pulumi.String("Running"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.standbypool.StandbyVirtualMachinePool;
 * import com.pulumi.azurenative.standbypool.StandbyVirtualMachinePoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var standbyVirtualMachinePool = new StandbyVirtualMachinePool("standbyVirtualMachinePool", StandbyVirtualMachinePoolArgs.builder()
 *             .attachedVirtualMachineScaleSetId("/subscriptions/8CC31D61-82D7-4B2B-B9DC-6B924DE7D229/resourceGroups/vmssRg/providers/Microsoft.Compute/virtualMachineScaleSets/myVmss")
 *             .elasticityProfile(Map.of("maxReadyCapacity", 304))
 *             .location("West US")
 *             .resourceGroupName("rgstandbypool")
 *             .standbyVirtualMachinePoolName("pool")
 *             .tags()
 *             .virtualMachineState("Running")
 *             .build());
 *     }
 * }
 * ```
 * ### StandbyVirtualMachinePools_CreateOrUpdate - generated by [MinimumSet] rule
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var standbyVirtualMachinePool = new AzureNative.StandbyPool.StandbyVirtualMachinePool("standbyVirtualMachinePool", new()
 *     {
 *         Location = "West US",
 *         ResourceGroupName = "rgstandbypool",
 *         StandbyVirtualMachinePoolName = "pool",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/standbypool/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := standbypool.NewStandbyVirtualMachinePool(ctx, "standbyVirtualMachinePool", &standbypool.StandbyVirtualMachinePoolArgs{
 * 			Location:                      pulumi.String("West US"),
 * 			ResourceGroupName:             pulumi.String("rgstandbypool"),
 * 			StandbyVirtualMachinePoolName: pulumi.String("pool"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.standbypool.StandbyVirtualMachinePool;
 * import com.pulumi.azurenative.standbypool.StandbyVirtualMachinePoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var standbyVirtualMachinePool = new StandbyVirtualMachinePool("standbyVirtualMachinePool", StandbyVirtualMachinePoolArgs.builder()
 *             .location("West US")
 *             .resourceGroupName("rgstandbypool")
 *             .standbyVirtualMachinePoolName("pool")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:standbypool:StandbyVirtualMachinePool pool /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.StandbyPool/standbyVirtualMachinePools/{standbyVirtualMachinePoolName}
 * ```
 */
public class StandbyVirtualMachinePool internal constructor(
    override val javaResource: com.pulumi.azurenative.standbypool.StandbyVirtualMachinePool,
) : KotlinCustomResource(javaResource, StandbyVirtualMachinePoolMapper) {
    /**
     * Specifies the fully qualified resource ID of a virtual machine scale set the pool is attached to.
     */
    public val attachedVirtualMachineScaleSetId: Output<String>?
        get() = javaResource.attachedVirtualMachineScaleSetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the elasticity profile of the standby virtual machine pools.
     */
    public val elasticityProfile: Output<StandbyVirtualMachinePoolElasticityProfileResponse>?
        get() = javaResource.elasticityProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    standbyVirtualMachinePoolElasticityProfileResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The status of the last operation.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Specifies the desired state of virtual machines in the pool.
     */
    public val virtualMachineState: Output<String>
        get() = javaResource.virtualMachineState().applyValue({ args0 -> args0 })
}

public object StandbyVirtualMachinePoolMapper : ResourceMapper<StandbyVirtualMachinePool> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.standbypool.StandbyVirtualMachinePool::class == javaResource::class

    override fun map(javaResource: Resource): StandbyVirtualMachinePool =
        StandbyVirtualMachinePool(
            javaResource as
                com.pulumi.azurenative.standbypool.StandbyVirtualMachinePool,
        )
}

/**
 * @see [StandbyVirtualMachinePool].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [StandbyVirtualMachinePool].
 */
public suspend fun standbyVirtualMachinePool(
    name: String,
    block: suspend StandbyVirtualMachinePoolResourceBuilder.() -> Unit,
): StandbyVirtualMachinePool {
    val builder = StandbyVirtualMachinePoolResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [StandbyVirtualMachinePool].
 * @param name The _unique_ name of the resulting resource.
 */
public fun standbyVirtualMachinePool(name: String): StandbyVirtualMachinePool {
    val builder = StandbyVirtualMachinePoolResourceBuilder()
    builder.name(name)
    return builder.build()
}
