@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.standbypool.kotlin.inputs

import com.pulumi.azurenative.standbypool.inputs.GetStandbyContainerGroupPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property standbyContainerGroupPoolName Name of the standby container group pool
 */
public data class GetStandbyContainerGroupPoolPlainArgs(
    public val resourceGroupName: String,
    public val standbyContainerGroupPoolName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.standbypool.inputs.GetStandbyContainerGroupPoolPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.standbypool.inputs.GetStandbyContainerGroupPoolPlainArgs =
        com.pulumi.azurenative.standbypool.inputs.GetStandbyContainerGroupPoolPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .standbyContainerGroupPoolName(standbyContainerGroupPoolName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStandbyContainerGroupPoolPlainArgs].
 */
@PulumiTagMarker
public class GetStandbyContainerGroupPoolPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var standbyContainerGroupPoolName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("agvctwseeqhvtqwj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the standby container group pool
     */
    @JvmName("bemoycfwpjmrvxad")
    public suspend fun standbyContainerGroupPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.standbyContainerGroupPoolName = mapped
    }

    internal fun build(): GetStandbyContainerGroupPoolPlainArgs =
        GetStandbyContainerGroupPoolPlainArgs(
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            standbyContainerGroupPoolName = standbyContainerGroupPoolName ?: throw
                PulumiNullFieldException("standbyContainerGroupPoolName"),
        )
}
