@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.asset.AssetOrArchive
import com.pulumi.azurenative.storage.BlobArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.BlobAccessTier
import com.pulumi.azurenative.storage.kotlin.enums.BlobType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a Blob within a Storage Container.
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:Blob myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/blobs/{blobName}
 * ```
 * @property accessTier The access tier of the storage blob.
 * @property accountName Specifies the storage account in which to create the storage container.
 * @property blobName The name of the storage blob. Must be unique within the storage container the blob is located.
 * @property containerName The name of the storage container in which this blob should be created.
 * @property contentMd5 The MD5 sum of the blob contents. Cannot be defined if blob type is Append.
 * @property contentType The content type of the storage blob. Defaults to `application/octet-stream`.
 * @property metadata A map of custom blob metadata.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property source An asset to copy to the blob contents. This field cannot be specified for Append blobs.
 * @property type The type of the storage blob to be created. Defaults to 'Block'.
 */
public data class BlobArgs(
    public val accessTier: Output<BlobAccessTier>? = null,
    public val accountName: Output<String>? = null,
    public val blobName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val contentMd5: Output<String>? = null,
    public val contentType: Output<String>? = null,
    public val metadata: Output<Map<String, String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<AssetOrArchive>? = null,
    public val type: Output<BlobType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.BlobArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.BlobArgs =
        com.pulumi.azurenative.storage.BlobArgs.builder()
            .accessTier(accessTier?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .blobName(blobName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .contentMd5(contentMd5?.applyValue({ args0 -> args0 }))
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [BlobArgs].
 */
@PulumiTagMarker
public class BlobArgsBuilder internal constructor() {
    private var accessTier: Output<BlobAccessTier>? = null

    private var accountName: Output<String>? = null

    private var blobName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var contentMd5: Output<String>? = null

    private var contentType: Output<String>? = null

    private var metadata: Output<Map<String, String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<AssetOrArchive>? = null

    private var type: Output<BlobType>? = null

    /**
     * @param value The access tier of the storage blob.
     */
    @JvmName("dpxdfnhnveqgyyda")
    public suspend fun accessTier(`value`: Output<BlobAccessTier>) {
        this.accessTier = value
    }

    /**
     * @param value Specifies the storage account in which to create the storage container.
     */
    @JvmName("bsulfaewalkfyvom")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the storage blob. Must be unique within the storage container the blob is located.
     */
    @JvmName("wiiqwbijbriiapub")
    public suspend fun blobName(`value`: Output<String>) {
        this.blobName = value
    }

    /**
     * @param value The name of the storage container in which this blob should be created.
     */
    @JvmName("fihcrqopmtwdaepa")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value The MD5 sum of the blob contents. Cannot be defined if blob type is Append.
     */
    @JvmName("mhfkwhvnmyhxbikk")
    public suspend fun contentMd5(`value`: Output<String>) {
        this.contentMd5 = value
    }

    /**
     * @param value The content type of the storage blob. Defaults to `application/octet-stream`.
     */
    @JvmName("jjcyflddigdowkvg")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value A map of custom blob metadata.
     */
    @JvmName("fygxlaitdxupmohv")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("ueqvycvgjbycapoi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value An asset to copy to the blob contents. This field cannot be specified for Append blobs.
     */
    @JvmName("gxgurwblljwyvfqu")
    public suspend fun source(`value`: Output<AssetOrArchive>) {
        this.source = value
    }

    /**
     * @param value The type of the storage blob to be created. Defaults to 'Block'.
     */
    @JvmName("creprittytsvllsq")
    public suspend fun type(`value`: Output<BlobType>) {
        this.type = value
    }

    /**
     * @param value The access tier of the storage blob.
     */
    @JvmName("qnnqbcetjbbpavyf")
    public suspend fun accessTier(`value`: BlobAccessTier?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessTier = mapped
    }

    /**
     * @param value Specifies the storage account in which to create the storage container.
     */
    @JvmName("ubicbkkhimukwhti")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the storage blob. Must be unique within the storage container the blob is located.
     */
    @JvmName("mrumlyiqqjbwolbm")
    public suspend fun blobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobName = mapped
    }

    /**
     * @param value The name of the storage container in which this blob should be created.
     */
    @JvmName("simnusniiujalwwy")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value The MD5 sum of the blob contents. Cannot be defined if blob type is Append.
     */
    @JvmName("mlytyupirhkteldj")
    public suspend fun contentMd5(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentMd5 = mapped
    }

    /**
     * @param value The content type of the storage blob. Defaults to `application/octet-stream`.
     */
    @JvmName("cgtylbpcyakjhiqg")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value A map of custom blob metadata.
     */
    @JvmName("wltfucmqkmqcbnqh")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values A map of custom blob metadata.
     */
    @JvmName("xgixookiyyhhugag")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("xsywtltvwlobhgfa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value An asset to copy to the blob contents. This field cannot be specified for Append blobs.
     */
    @JvmName("qigvcgqagqroeevh")
    public suspend fun source(`value`: AssetOrArchive?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The type of the storage blob to be created. Defaults to 'Block'.
     */
    @JvmName("tpkwkkyieiiglfqu")
    public suspend fun type(`value`: BlobType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): BlobArgs = BlobArgs(
        accessTier = accessTier,
        accountName = accountName,
        blobName = blobName,
        containerName = containerName,
        contentMd5 = contentMd5,
        contentType = contentType,
        metadata = metadata,
        resourceGroupName = resourceGroupName,
        source = source,
        type = type,
    )
}
