@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.BlobContainerLegalHoldArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * .
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:BlobContainerLegalHold myresource1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/blobServices/default/containers/{containerName}/legalHold
 * ```
 * @property accountName Name of the Storage Account.
 * @property allowProtectedAppendWritesAll When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining legal hold protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
 * @property containerName Name of the Blob Container.
 * @property resourceGroupName Name of the resource group that contains the storage account.
 * @property tags List of legal hold tags. Each tag should be 3 to 23 alphanumeric characters and is normalized to lower case at SRP.
 */
public data class BlobContainerLegalHoldArgs(
    public val accountName: Output<String>? = null,
    public val allowProtectedAppendWritesAll: Output<Boolean>? = null,
    public val containerName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.BlobContainerLegalHoldArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.BlobContainerLegalHoldArgs =
        com.pulumi.azurenative.storage.BlobContainerLegalHoldArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .allowProtectedAppendWritesAll(allowProtectedAppendWritesAll?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BlobContainerLegalHoldArgs].
 */
@PulumiTagMarker
public class BlobContainerLegalHoldArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var allowProtectedAppendWritesAll: Output<Boolean>? = null

    private var containerName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<List<String>>? = null

    /**
     * @param value Name of the Storage Account.
     */
    @JvmName("dnieylvymdmrprky")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining legal hold protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
     */
    @JvmName("ievswrboimcbhdib")
    public suspend fun allowProtectedAppendWritesAll(`value`: Output<Boolean>) {
        this.allowProtectedAppendWritesAll = value
    }

    /**
     * @param value Name of the Blob Container.
     */
    @JvmName("soijayjqxgkifvuc")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Name of the resource group that contains the storage account.
     */
    @JvmName("nbocsulvmwtghtde")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value List of legal hold tags. Each tag should be 3 to 23 alphanumeric characters and is normalized to lower case at SRP.
     */
    @JvmName("xxowmijtateqqwin")
    public suspend fun tags(`value`: Output<List<String>>) {
        this.tags = value
    }

    @JvmName("ghwgbwoyssylmtnw")
    public suspend fun tags(vararg values: Output<String>) {
        this.tags = Output.all(values.asList())
    }

    /**
     * @param values List of legal hold tags. Each tag should be 3 to 23 alphanumeric characters and is normalized to lower case at SRP.
     */
    @JvmName("cdlatlqjqyqedwdi")
    public suspend fun tags(values: List<Output<String>>) {
        this.tags = Output.all(values)
    }

    /**
     * @param value Name of the Storage Account.
     */
    @JvmName("rxnklcbjavljobrd")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value When enabled, new blocks can be written to both 'Append and Bock Blobs' while maintaining legal hold protection and compliance. Only new blocks can be added and any existing blocks cannot be modified or deleted.
     */
    @JvmName("nfpppgwkaciefnwq")
    public suspend fun allowProtectedAppendWritesAll(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowProtectedAppendWritesAll = mapped
    }

    /**
     * @param value Name of the Blob Container.
     */
    @JvmName("tbdcbrludjwwprdr")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Name of the resource group that contains the storage account.
     */
    @JvmName("buasxsptyakocdke")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value List of legal hold tags. Each tag should be 3 to 23 alphanumeric characters and is normalized to lower case at SRP.
     */
    @JvmName("hqkjcpcpvhfunnaa")
    public suspend fun tags(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values List of legal hold tags. Each tag should be 3 to 23 alphanumeric characters and is normalized to lower case at SRP.
     */
    @JvmName("budubpajmtfxfukn")
    public suspend fun tags(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): BlobContainerLegalHoldArgs = BlobContainerLegalHoldArgs(
        accountName = accountName,
        allowProtectedAppendWritesAll = allowProtectedAppendWritesAll,
        containerName = containerName,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
