@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.BlobInventoryPolicyArgs.builder
import com.pulumi.azurenative.storage.kotlin.inputs.BlobInventoryPolicySchemaArgs
import com.pulumi.azurenative.storage.kotlin.inputs.BlobInventoryPolicySchemaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The storage account blob inventory policy.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### StorageAccountSetBlobInventoryPolicy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobInventoryPolicy = new AzureNative.Storage.BlobInventoryPolicy("blobInventoryPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         BlobInventoryPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.BlobInventoryPolicySchemaArgs
 *         {
 *             Enabled = true,
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.BlobInventoryPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.BlobInventoryPolicyDefinitionArgs
 *                     {
 *                         Filters = new AzureNative.Storage.Inputs.BlobInventoryPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                                 "appendBlob",
 *                                 "pageBlob",
 *                             },
 *                             ExcludePrefix = new[]
 *                             {
 *                                 "excludeprefix1",
 *                                 "excludeprefix2",
 *                             },
 *                             IncludeBlobVersions = true,
 *                             IncludeSnapshots = true,
 *                             PrefixMatch = new[]
 *                             {
 *                                 "inventoryprefix1",
 *                                 "inventoryprefix2",
 *                             },
 *                         },
 *                         Format = "Csv",
 *                         ObjectType = "Blob",
 *                         Schedule = "Daily",
 *                         SchemaFields = new[]
 *                         {
 *                             "Name",
 *                             "Creation-Time",
 *                             "Last-Modified",
 *                             "Content-Length",
 *                             "Content-MD5",
 *                             "BlobType",
 *                             "AccessTier",
 *                             "AccessTierChangeTime",
 *                             "Snapshot",
 *                             "VersionId",
 *                             "IsCurrentVersion",
 *                             "Metadata",
 *                         },
 *                     },
 *                     Destination = "container1",
 *                     Enabled = true,
 *                     Name = "inventoryPolicyRule1",
 *                 },
 *                 new AzureNative.Storage.Inputs.BlobInventoryPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.BlobInventoryPolicyDefinitionArgs
 *                     {
 *                         Format = "Parquet",
 *                         ObjectType = "Container",
 *                         Schedule = "Weekly",
 *                         SchemaFields = new[]
 *                         {
 *                             "Name",
 *                             "Last-Modified",
 *                             "Metadata",
 *                             "LeaseStatus",
 *                             "LeaseState",
 *                             "LeaseDuration",
 *                             "PublicAccess",
 *                             "HasImmutabilityPolicy",
 *                             "HasLegalHold",
 *                         },
 *                     },
 *                     Destination = "container2",
 *                     Enabled = true,
 *                     Name = "inventoryPolicyRule2",
 *                 },
 *             },
 *             Type = "Inventory",
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewBlobInventoryPolicy(ctx, "blobInventoryPolicy", &storage.BlobInventoryPolicyArgs{
 * AccountName: pulumi.String("sto9699"),
 * BlobInventoryPolicyName: pulumi.String("default"),
 * Policy: storage.BlobInventoryPolicySchemaResponse{
 * Enabled: pulumi.Bool(true),
 * Rules: storage.BlobInventoryPolicyRuleArray{
 * interface{}{
 * Definition: interface{}{
 * Filters: &storage.BlobInventoryPolicyFilterArgs{
 * BlobTypes: pulumi.StringArray{
 * pulumi.String("blockBlob"),
 * pulumi.String("appendBlob"),
 * pulumi.String("pageBlob"),
 * },
 * ExcludePrefix: pulumi.StringArray{
 * pulumi.String("excludeprefix1"),
 * pulumi.String("excludeprefix2"),
 * },
 * IncludeBlobVersions: pulumi.Bool(true),
 * IncludeSnapshots: pulumi.Bool(true),
 * PrefixMatch: pulumi.StringArray{
 * pulumi.String("inventoryprefix1"),
 * pulumi.String("inventoryprefix2"),
 * },
 * },
 * Format: pulumi.String("Csv"),
 * ObjectType: pulumi.String("Blob"),
 * Schedule: pulumi.String("Daily"),
 * SchemaFields: pulumi.StringArray{
 * pulumi.String("Name"),
 * pulumi.String("Creation-Time"),
 * pulumi.String("Last-Modified"),
 * pulumi.String("Content-Length"),
 * pulumi.String("Content-MD5"),
 * pulumi.String("BlobType"),
 * pulumi.String("AccessTier"),
 * pulumi.String("AccessTierChangeTime"),
 * pulumi.String("Snapshot"),
 * pulumi.String("VersionId"),
 * pulumi.String("IsCurrentVersion"),
 * pulumi.String("Metadata"),
 * },
 * },
 * Destination: pulumi.String("container1"),
 * Enabled: pulumi.Bool(true),
 * Name: pulumi.String("inventoryPolicyRule1"),
 * },
 * interface{}{
 * Definition: &storage.BlobInventoryPolicyDefinitionArgs{
 * Format: pulumi.String("Parquet"),
 * ObjectType: pulumi.String("Container"),
 * Schedule: pulumi.String("Weekly"),
 * SchemaFields: pulumi.StringArray{
 * pulumi.String("Name"),
 * pulumi.String("Last-Modified"),
 * pulumi.String("Metadata"),
 * pulumi.String("LeaseStatus"),
 * pulumi.String("LeaseState"),
 * pulumi.String("LeaseDuration"),
 * pulumi.String("PublicAccess"),
 * pulumi.String("HasImmutabilityPolicy"),
 * pulumi.String("HasLegalHold"),
 * },
 * },
 * Destination: pulumi.String("container2"),
 * Enabled: pulumi.Bool(true),
 * Name: pulumi.String("inventoryPolicyRule2"),
 * },
 * },
 * Type: pulumi.String("Inventory"),
 * },
 * ResourceGroupName: pulumi.String("res7687"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobInventoryPolicy;
 * import com.pulumi.azurenative.storage.BlobInventoryPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobInventoryPolicy = new BlobInventoryPolicy("blobInventoryPolicy", BlobInventoryPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .blobInventoryPolicyName("default")
 *             .policy(Map.ofEntries(
 *                 Map.entry("enabled", true),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("definition", Map.ofEntries(
 *                             Map.entry("filters", Map.ofEntries(
 *                                 Map.entry("blobTypes",
 *                                     "blockBlob",
 *                                     "appendBlob",
 *                                     "pageBlob"),
 *                                 Map.entry("excludePrefix",
 *                                     "excludeprefix1",
 *                                     "excludeprefix2"),
 *                                 Map.entry("includeBlobVersions", true),
 *                                 Map.entry("includeSnapshots", true),
 *                                 Map.entry("prefixMatch",
 *                                     "inventoryprefix1",
 *                                     "inventoryprefix2")
 *                             )),
 *                             Map.entry("format", "Csv"),
 *                             Map.entry("objectType", "Blob"),
 *                             Map.entry("schedule", "Daily"),
 *                             Map.entry("schemaFields",
 *                                 "Name",
 *                                 "Creation-Time",
 *                                 "Last-Modified",
 *                                 "Content-Length",
 *                                 "Content-MD5",
 *                                 "BlobType",
 *                                 "AccessTier",
 *                                 "AccessTierChangeTime",
 *                                 "Snapshot",
 *                                 "VersionId",
 *                                 "IsCurrentVersion",
 *                                 "Metadata")
 *                         )),
 *                         Map.entry("destination", "container1"),
 *                         Map.entry("enabled", true),
 *                         Map.entry("name", "inventoryPolicyRule1")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("definition", Map.ofEntries(
 *                             Map.entry("format", "Parquet"),
 *                             Map.entry("objectType", "Container"),
 *                             Map.entry("schedule", "Weekly"),
 *                             Map.entry("schemaFields",
 *                                 "Name",
 *                                 "Last-Modified",
 *                                 "Metadata",
 *                                 "LeaseStatus",
 *                                 "LeaseState",
 *                                 "LeaseDuration",
 *                                 "PublicAccess",
 *                                 "HasImmutabilityPolicy",
 *                                 "HasLegalHold")
 *                         )),
 *                         Map.entry("destination", "container2"),
 *                         Map.entry("enabled", true),
 *                         Map.entry("name", "inventoryPolicyRule2")
 *                     )),
 *                 Map.entry("type", "Inventory")
 *             ))
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetBlobInventoryPolicyIncludeDeleteAndNewSchemaForHnsAccount
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobInventoryPolicy = new AzureNative.Storage.BlobInventoryPolicy("blobInventoryPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         BlobInventoryPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.BlobInventoryPolicySchemaArgs
 *         {
 *             Enabled = true,
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.BlobInventoryPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.BlobInventoryPolicyDefinitionArgs
 *                     {
 *                         Filters = new AzureNative.Storage.Inputs.BlobInventoryPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                                 "appendBlob",
 *                                 "pageBlob",
 *                             },
 *                             ExcludePrefix = new[]
 *                             {
 *                                 "excludeprefix1",
 *                                 "excludeprefix2",
 *                             },
 *                             IncludeBlobVersions = true,
 *                             IncludeDeleted = true,
 *                             IncludeSnapshots = true,
 *                             PrefixMatch = new[]
 *                             {
 *                                 "inventoryprefix1",
 *                                 "inventoryprefix2",
 *                             },
 *                         },
 *                         Format = "Csv",
 *                         ObjectType = "Blob",
 *                         Schedule = "Daily",
 *                         SchemaFields = new[]
 *                         {
 *                             "Name",
 *                             "Creation-Time",
 *                             "Last-Modified",
 *                             "Content-Length",
 *                             "Content-MD5",
 *                             "BlobType",
 *                             "AccessTier",
 *                             "AccessTierChangeTime",
 *                             "Snapshot",
 *                             "VersionId",
 *                             "IsCurrentVersion",
 *                             "ContentType",
 *                             "ContentEncoding",
 *                             "ContentLanguage",
 *                             "ContentCRC64",
 *                             "CacheControl",
 *                             "Metadata",
 *                             "DeletionId",
 *                             "Deleted",
 *                             "DeletedTime",
 *                             "RemainingRetentionDays",
 *                         },
 *                     },
 *                     Destination = "container1",
 *                     Enabled = true,
 *                     Name = "inventoryPolicyRule1",
 *                 },
 *                 new AzureNative.Storage.Inputs.BlobInventoryPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.BlobInventoryPolicyDefinitionArgs
 *                     {
 *                         Format = "Parquet",
 *                         ObjectType = "Container",
 *                         Schedule = "Weekly",
 *                         SchemaFields = new[]
 *                         {
 *                             "Name",
 *                             "Last-Modified",
 *                             "Metadata",
 *                             "LeaseStatus",
 *                             "LeaseState",
 *                             "LeaseDuration",
 *                             "PublicAccess",
 *                             "HasImmutabilityPolicy",
 *                             "HasLegalHold",
 *                             "Etag",
 *                             "DefaultEncryptionScope",
 *                             "DenyEncryptionScopeOverride",
 *                             "ImmutableStorageWithVersioningEnabled",
 *                             "Deleted",
 *                             "Version",
 *                             "DeletedTime",
 *                             "RemainingRetentionDays",
 *                         },
 *                     },
 *                     Destination = "container2",
 *                     Enabled = true,
 *                     Name = "inventoryPolicyRule2",
 *                 },
 *             },
 *             Type = "Inventory",
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewBlobInventoryPolicy(ctx, "blobInventoryPolicy", &storage.BlobInventoryPolicyArgs{
 * AccountName: pulumi.String("sto9699"),
 * BlobInventoryPolicyName: pulumi.String("default"),
 * Policy: storage.BlobInventoryPolicySchemaResponse{
 * Enabled: pulumi.Bool(true),
 * Rules: storage.BlobInventoryPolicyRuleArray{
 * interface{}{
 * Definition: interface{}{
 * Filters: &storage.BlobInventoryPolicyFilterArgs{
 * BlobTypes: pulumi.StringArray{
 * pulumi.String("blockBlob"),
 * pulumi.String("appendBlob"),
 * pulumi.String("pageBlob"),
 * },
 * ExcludePrefix: pulumi.StringArray{
 * pulumi.String("excludeprefix1"),
 * pulumi.String("excludeprefix2"),
 * },
 * IncludeBlobVersions: pulumi.Bool(true),
 * IncludeDeleted: pulumi.Bool(true),
 * IncludeSnapshots: pulumi.Bool(true),
 * PrefixMatch: pulumi.StringArray{
 * pulumi.String("inventoryprefix1"),
 * pulumi.String("inventoryprefix2"),
 * },
 * },
 * Format: pulumi.String("Csv"),
 * ObjectType: pulumi.String("Blob"),
 * Schedule: pulumi.String("Daily"),
 * SchemaFields: pulumi.StringArray{
 * pulumi.String("Name"),
 * pulumi.String("Creation-Time"),
 * pulumi.String("Last-Modified"),
 * pulumi.String("Content-Length"),
 * pulumi.String("Content-MD5"),
 * pulumi.String("BlobType"),
 * pulumi.String("AccessTier"),
 * pulumi.String("AccessTierChangeTime"),
 * pulumi.String("Snapshot"),
 * pulumi.String("VersionId"),
 * pulumi.String("IsCurrentVersion"),
 * pulumi.String("ContentType"),
 * pulumi.String("ContentEncoding"),
 * pulumi.String("ContentLanguage"),
 * pulumi.String("ContentCRC64"),
 * pulumi.String("CacheControl"),
 * pulumi.String("Metadata"),
 * pulumi.String("DeletionId"),
 * pulumi.String("Deleted"),
 * pulumi.String("DeletedTime"),
 * pulumi.String("RemainingRetentionDays"),
 * },
 * },
 * Destination: pulumi.String("container1"),
 * Enabled: pulumi.Bool(true),
 * Name: pulumi.String("inventoryPolicyRule1"),
 * },
 * interface{}{
 * Definition: &storage.BlobInventoryPolicyDefinitionArgs{
 * Format: pulumi.String("Parquet"),
 * ObjectType: pulumi.String("Container"),
 * Schedule: pulumi.String("Weekly"),
 * SchemaFields: pulumi.StringArray{
 * pulumi.String("Name"),
 * pulumi.String("Last-Modified"),
 * pulumi.String("Metadata"),
 * pulumi.String("LeaseStatus"),
 * pulumi.String("LeaseState"),
 * pulumi.String("LeaseDuration"),
 * pulumi.String("PublicAccess"),
 * pulumi.String("HasImmutabilityPolicy"),
 * pulumi.String("HasLegalHold"),
 * pulumi.String("Etag"),
 * pulumi.String("DefaultEncryptionScope"),
 * pulumi.String("DenyEncryptionScopeOverride"),
 * pulumi.String("ImmutableStorageWithVersioningEnabled"),
 * pulumi.String("Deleted"),
 * pulumi.String("Version"),
 * pulumi.String("DeletedTime"),
 * pulumi.String("RemainingRetentionDays"),
 * },
 * },
 * Destination: pulumi.String("container2"),
 * Enabled: pulumi.Bool(true),
 * Name: pulumi.String("inventoryPolicyRule2"),
 * },
 * },
 * Type: pulumi.String("Inventory"),
 * },
 * ResourceGroupName: pulumi.String("res7687"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobInventoryPolicy;
 * import com.pulumi.azurenative.storage.BlobInventoryPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobInventoryPolicy = new BlobInventoryPolicy("blobInventoryPolicy", BlobInventoryPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .blobInventoryPolicyName("default")
 *             .policy(Map.ofEntries(
 *                 Map.entry("enabled", true),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("definition", Map.ofEntries(
 *                             Map.entry("filters", Map.ofEntries(
 *                                 Map.entry("blobTypes",
 *                                     "blockBlob",
 *                                     "appendBlob",
 *                                     "pageBlob"),
 *                                 Map.entry("excludePrefix",
 *                                     "excludeprefix1",
 *                                     "excludeprefix2"),
 *                                 Map.entry("includeBlobVersions", true),
 *                                 Map.entry("includeDeleted", true),
 *                                 Map.entry("includeSnapshots", true),
 *                                 Map.entry("prefixMatch",
 *                                     "inventoryprefix1",
 *                                     "inventoryprefix2")
 *                             )),
 *                             Map.entry("format", "Csv"),
 *                             Map.entry("objectType", "Blob"),
 *                             Map.entry("schedule", "Daily"),
 *                             Map.entry("schemaFields",
 *                                 "Name",
 *                                 "Creation-Time",
 *                                 "Last-Modified",
 *                                 "Content-Length",
 *                                 "Content-MD5",
 *                                 "BlobType",
 *                                 "AccessTier",
 *                                 "AccessTierChangeTime",
 *                                 "Snapshot",
 *                                 "VersionId",
 *                                 "IsCurrentVersion",
 *                                 "ContentType",
 *                                 "ContentEncoding",
 *                                 "ContentLanguage",
 *                                 "ContentCRC64",
 *                                 "CacheControl",
 *                                 "Metadata",
 *                                 "DeletionId",
 *                                 "Deleted",
 *                                 "DeletedTime",
 *                                 "RemainingRetentionDays")
 *                         )),
 *                         Map.entry("destination", "container1"),
 *                         Map.entry("enabled", true),
 *                         Map.entry("name", "inventoryPolicyRule1")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("definition", Map.ofEntries(
 *                             Map.entry("format", "Parquet"),
 *                             Map.entry("objectType", "Container"),
 *                             Map.entry("schedule", "Weekly"),
 *                             Map.entry("schemaFields",
 *                                 "Name",
 *                                 "Last-Modified",
 *                                 "Metadata",
 *                                 "LeaseStatus",
 *                                 "LeaseState",
 *                                 "LeaseDuration",
 *                                 "PublicAccess",
 *                                 "HasImmutabilityPolicy",
 *                                 "HasLegalHold",
 *                                 "Etag",
 *                                 "DefaultEncryptionScope",
 *                                 "DenyEncryptionScopeOverride",
 *                                 "ImmutableStorageWithVersioningEnabled",
 *                                 "Deleted",
 *                                 "Version",
 *                                 "DeletedTime",
 *                                 "RemainingRetentionDays")
 *                         )),
 *                         Map.entry("destination", "container2"),
 *                         Map.entry("enabled", true),
 *                         Map.entry("name", "inventoryPolicyRule2")
 *                     )),
 *                 Map.entry("type", "Inventory")
 *             ))
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountSetBlobInventoryPolicyIncludeDeleteAndNewSchemaForNonHnsAccount
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var blobInventoryPolicy = new AzureNative.Storage.BlobInventoryPolicy("blobInventoryPolicy", new()
 *     {
 *         AccountName = "sto9699",
 *         BlobInventoryPolicyName = "default",
 *         Policy = new AzureNative.Storage.Inputs.BlobInventoryPolicySchemaArgs
 *         {
 *             Enabled = true,
 *             Rules = new[]
 *             {
 *                 new AzureNative.Storage.Inputs.BlobInventoryPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.BlobInventoryPolicyDefinitionArgs
 *                     {
 *                         Filters = new AzureNative.Storage.Inputs.BlobInventoryPolicyFilterArgs
 *                         {
 *                             BlobTypes = new[]
 *                             {
 *                                 "blockBlob",
 *                                 "appendBlob",
 *                                 "pageBlob",
 *                             },
 *                             ExcludePrefix = new[]
 *                             {
 *                                 "excludeprefix1",
 *                                 "excludeprefix2",
 *                             },
 *                             IncludeBlobVersions = true,
 *                             IncludeDeleted = true,
 *                             IncludeSnapshots = true,
 *                             PrefixMatch = new[]
 *                             {
 *                                 "inventoryprefix1",
 *                                 "inventoryprefix2",
 *                             },
 *                         },
 *                         Format = "Csv",
 *                         ObjectType = "Blob",
 *                         Schedule = "Daily",
 *                         SchemaFields = new[]
 *                         {
 *                             "Name",
 *                             "Creation-Time",
 *                             "Last-Modified",
 *                             "Content-Length",
 *                             "Content-MD5",
 *                             "BlobType",
 *                             "AccessTier",
 *                             "AccessTierChangeTime",
 *                             "Snapshot",
 *                             "VersionId",
 *                             "IsCurrentVersion",
 *                             "Tags",
 *                             "ContentType",
 *                             "ContentEncoding",
 *                             "ContentLanguage",
 *                             "ContentCRC64",
 *                             "CacheControl",
 *                             "Metadata",
 *                             "Deleted",
 *                             "RemainingRetentionDays",
 *                         },
 *                     },
 *                     Destination = "container1",
 *                     Enabled = true,
 *                     Name = "inventoryPolicyRule1",
 *                 },
 *                 new AzureNative.Storage.Inputs.BlobInventoryPolicyRuleArgs
 *                 {
 *                     Definition = new AzureNative.Storage.Inputs.BlobInventoryPolicyDefinitionArgs
 *                     {
 *                         Format = "Parquet",
 *                         ObjectType = "Container",
 *                         Schedule = "Weekly",
 *                         SchemaFields = new[]
 *                         {
 *                             "Name",
 *                             "Last-Modified",
 *                             "Metadata",
 *                             "LeaseStatus",
 *                             "LeaseState",
 *                             "LeaseDuration",
 *                             "PublicAccess",
 *                             "HasImmutabilityPolicy",
 *                             "HasLegalHold",
 *                             "Etag",
 *                             "DefaultEncryptionScope",
 *                             "DenyEncryptionScopeOverride",
 *                             "ImmutableStorageWithVersioningEnabled",
 *                             "Deleted",
 *                             "Version",
 *                             "DeletedTime",
 *                             "RemainingRetentionDays",
 *                         },
 *                     },
 *                     Destination = "container2",
 *                     Enabled = true,
 *                     Name = "inventoryPolicyRule2",
 *                 },
 *             },
 *             Type = "Inventory",
 *         },
 *         ResourceGroupName = "res7687",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := storage.NewBlobInventoryPolicy(ctx, "blobInventoryPolicy", &storage.BlobInventoryPolicyArgs{
 * AccountName: pulumi.String("sto9699"),
 * BlobInventoryPolicyName: pulumi.String("default"),
 * Policy: storage.BlobInventoryPolicySchemaResponse{
 * Enabled: pulumi.Bool(true),
 * Rules: storage.BlobInventoryPolicyRuleArray{
 * interface{}{
 * Definition: interface{}{
 * Filters: &storage.BlobInventoryPolicyFilterArgs{
 * BlobTypes: pulumi.StringArray{
 * pulumi.String("blockBlob"),
 * pulumi.String("appendBlob"),
 * pulumi.String("pageBlob"),
 * },
 * ExcludePrefix: pulumi.StringArray{
 * pulumi.String("excludeprefix1"),
 * pulumi.String("excludeprefix2"),
 * },
 * IncludeBlobVersions: pulumi.Bool(true),
 * IncludeDeleted: pulumi.Bool(true),
 * IncludeSnapshots: pulumi.Bool(true),
 * PrefixMatch: pulumi.StringArray{
 * pulumi.String("inventoryprefix1"),
 * pulumi.String("inventoryprefix2"),
 * },
 * },
 * Format: pulumi.String("Csv"),
 * ObjectType: pulumi.String("Blob"),
 * Schedule: pulumi.String("Daily"),
 * SchemaFields: pulumi.StringArray{
 * pulumi.String("Name"),
 * pulumi.String("Creation-Time"),
 * pulumi.String("Last-Modified"),
 * pulumi.String("Content-Length"),
 * pulumi.String("Content-MD5"),
 * pulumi.String("BlobType"),
 * pulumi.String("AccessTier"),
 * pulumi.String("AccessTierChangeTime"),
 * pulumi.String("Snapshot"),
 * pulumi.String("VersionId"),
 * pulumi.String("IsCurrentVersion"),
 * pulumi.String("Tags"),
 * pulumi.String("ContentType"),
 * pulumi.String("ContentEncoding"),
 * pulumi.String("ContentLanguage"),
 * pulumi.String("ContentCRC64"),
 * pulumi.String("CacheControl"),
 * pulumi.String("Metadata"),
 * pulumi.String("Deleted"),
 * pulumi.String("RemainingRetentionDays"),
 * },
 * },
 * Destination: pulumi.String("container1"),
 * Enabled: pulumi.Bool(true),
 * Name: pulumi.String("inventoryPolicyRule1"),
 * },
 * interface{}{
 * Definition: &storage.BlobInventoryPolicyDefinitionArgs{
 * Format: pulumi.String("Parquet"),
 * ObjectType: pulumi.String("Container"),
 * Schedule: pulumi.String("Weekly"),
 * SchemaFields: pulumi.StringArray{
 * pulumi.String("Name"),
 * pulumi.String("Last-Modified"),
 * pulumi.String("Metadata"),
 * pulumi.String("LeaseStatus"),
 * pulumi.String("LeaseState"),
 * pulumi.String("LeaseDuration"),
 * pulumi.String("PublicAccess"),
 * pulumi.String("HasImmutabilityPolicy"),
 * pulumi.String("HasLegalHold"),
 * pulumi.String("Etag"),
 * pulumi.String("DefaultEncryptionScope"),
 * pulumi.String("DenyEncryptionScopeOverride"),
 * pulumi.String("ImmutableStorageWithVersioningEnabled"),
 * pulumi.String("Deleted"),
 * pulumi.String("Version"),
 * pulumi.String("DeletedTime"),
 * pulumi.String("RemainingRetentionDays"),
 * },
 * },
 * Destination: pulumi.String("container2"),
 * Enabled: pulumi.Bool(true),
 * Name: pulumi.String("inventoryPolicyRule2"),
 * },
 * },
 * Type: pulumi.String("Inventory"),
 * },
 * ResourceGroupName: pulumi.String("res7687"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.BlobInventoryPolicy;
 * import com.pulumi.azurenative.storage.BlobInventoryPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var blobInventoryPolicy = new BlobInventoryPolicy("blobInventoryPolicy", BlobInventoryPolicyArgs.builder()
 *             .accountName("sto9699")
 *             .blobInventoryPolicyName("default")
 *             .policy(Map.ofEntries(
 *                 Map.entry("enabled", true),
 *                 Map.entry("rules",
 *                     Map.ofEntries(
 *                         Map.entry("definition", Map.ofEntries(
 *                             Map.entry("filters", Map.ofEntries(
 *                                 Map.entry("blobTypes",
 *                                     "blockBlob",
 *                                     "appendBlob",
 *                                     "pageBlob"),
 *                                 Map.entry("excludePrefix",
 *                                     "excludeprefix1",
 *                                     "excludeprefix2"),
 *                                 Map.entry("includeBlobVersions", true),
 *                                 Map.entry("includeDeleted", true),
 *                                 Map.entry("includeSnapshots", true),
 *                                 Map.entry("prefixMatch",
 *                                     "inventoryprefix1",
 *                                     "inventoryprefix2")
 *                             )),
 *                             Map.entry("format", "Csv"),
 *                             Map.entry("objectType", "Blob"),
 *                             Map.entry("schedule", "Daily"),
 *                             Map.entry("schemaFields",
 *                                 "Name",
 *                                 "Creation-Time",
 *                                 "Last-Modified",
 *                                 "Content-Length",
 *                                 "Content-MD5",
 *                                 "BlobType",
 *                                 "AccessTier",
 *                                 "AccessTierChangeTime",
 *                                 "Snapshot",
 *                                 "VersionId",
 *                                 "IsCurrentVersion",
 *                                 "Tags",
 *                                 "ContentType",
 *                                 "ContentEncoding",
 *                                 "ContentLanguage",
 *                                 "ContentCRC64",
 *                                 "CacheControl",
 *                                 "Metadata",
 *                                 "Deleted",
 *                                 "RemainingRetentionDays")
 *                         )),
 *                         Map.entry("destination", "container1"),
 *                         Map.entry("enabled", true),
 *                         Map.entry("name", "inventoryPolicyRule1")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("definition", Map.ofEntries(
 *                             Map.entry("format", "Parquet"),
 *                             Map.entry("objectType", "Container"),
 *                             Map.entry("schedule", "Weekly"),
 *                             Map.entry("schemaFields",
 *                                 "Name",
 *                                 "Last-Modified",
 *                                 "Metadata",
 *                                 "LeaseStatus",
 *                                 "LeaseState",
 *                                 "LeaseDuration",
 *                                 "PublicAccess",
 *                                 "HasImmutabilityPolicy",
 *                                 "HasLegalHold",
 *                                 "Etag",
 *                                 "DefaultEncryptionScope",
 *                                 "DenyEncryptionScopeOverride",
 *                                 "ImmutableStorageWithVersioningEnabled",
 *                                 "Deleted",
 *                                 "Version",
 *                                 "DeletedTime",
 *                                 "RemainingRetentionDays")
 *                         )),
 *                         Map.entry("destination", "container2"),
 *                         Map.entry("enabled", true),
 *                         Map.entry("name", "inventoryPolicyRule2")
 *                     )),
 *                 Map.entry("type", "Inventory")
 *             ))
 *             .resourceGroupName("res7687")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:BlobInventoryPolicy DefaultInventoryPolicy /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/inventoryPolicies/{blobInventoryPolicyName}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property blobInventoryPolicyName The name of the storage account blob inventory policy. It should always be 'default'
 * @property policy The storage account blob inventory policy object. It is composed of policy rules.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class BlobInventoryPolicyArgs(
    public val accountName: Output<String>? = null,
    public val blobInventoryPolicyName: Output<String>? = null,
    public val policy: Output<BlobInventoryPolicySchemaArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.BlobInventoryPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.BlobInventoryPolicyArgs =
        com.pulumi.azurenative.storage.BlobInventoryPolicyArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .blobInventoryPolicyName(blobInventoryPolicyName?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BlobInventoryPolicyArgs].
 */
@PulumiTagMarker
public class BlobInventoryPolicyArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var blobInventoryPolicyName: Output<String>? = null

    private var policy: Output<BlobInventoryPolicySchemaArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("rqtcqxnflvavcahm")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The name of the storage account blob inventory policy. It should always be 'default'
     */
    @JvmName("rgufgkfybdypbncg")
    public suspend fun blobInventoryPolicyName(`value`: Output<String>) {
        this.blobInventoryPolicyName = value
    }

    /**
     * @param value The storage account blob inventory policy object. It is composed of policy rules.
     */
    @JvmName("eamiduuimklxnwbi")
    public suspend fun policy(`value`: Output<BlobInventoryPolicySchemaArgs>) {
        this.policy = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("nkmnqyhweoutqwgi")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("ktofdrwnlflspamq")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The name of the storage account blob inventory policy. It should always be 'default'
     */
    @JvmName("hcpepyhjgktbiids")
    public suspend fun blobInventoryPolicyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobInventoryPolicyName = mapped
    }

    /**
     * @param value The storage account blob inventory policy object. It is composed of policy rules.
     */
    @JvmName("aljwqkpnrucbaenu")
    public suspend fun policy(`value`: BlobInventoryPolicySchemaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument The storage account blob inventory policy object. It is composed of policy rules.
     */
    @JvmName("ogwxdujjgotltupd")
    public suspend fun policy(argument: suspend BlobInventoryPolicySchemaArgsBuilder.() -> Unit) {
        val toBeMapped = BlobInventoryPolicySchemaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("vxppefmxhdtbnjqm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): BlobInventoryPolicyArgs = BlobInventoryPolicyArgs(
        accountName = accountName,
        blobInventoryPolicyName = blobInventoryPolicyName,
        policy = policy,
        resourceGroupName = resourceGroupName,
    )
}
