@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.FileShareArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.EnabledProtocols
import com.pulumi.azurenative.storage.kotlin.enums.RootSquashType
import com.pulumi.azurenative.storage.kotlin.enums.ShareAccessTier
import com.pulumi.azurenative.storage.kotlin.inputs.SignedIdentifierArgs
import com.pulumi.azurenative.storage.kotlin.inputs.SignedIdentifierArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Properties of the file share, including Id, resource name, resource type, Etag.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### Create NFS Shares
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileShare = new AzureNative.Storage.FileShare("fileShare", new()
 *     {
 *         AccountName = "sto666",
 *         EnabledProtocols = "NFS",
 *         ResourceGroupName = "res346",
 *         ShareName = "share1235",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewFileShare(ctx, "fileShare", &storage.FileShareArgs{
 * 			AccountName:       pulumi.String("sto666"),
 * 			EnabledProtocols:  pulumi.String("NFS"),
 * 			ResourceGroupName: pulumi.String("res346"),
 * 			ShareName:         pulumi.String("share1235"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.FileShare;
 * import com.pulumi.azurenative.storage.FileShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileShare = new FileShare("fileShare", FileShareArgs.builder()
 *             .accountName("sto666")
 *             .enabledProtocols("NFS")
 *             .resourceGroupName("res346")
 *             .shareName("share1235")
 *             .build());
 *     }
 * }
 * ```
 * ### PutShares
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileShare = new AzureNative.Storage.FileShare("fileShare", new()
 *     {
 *         AccountName = "sto328",
 *         ResourceGroupName = "res3376",
 *         ShareName = "share6185",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewFileShare(ctx, "fileShare", &storage.FileShareArgs{
 * 			AccountName:       pulumi.String("sto328"),
 * 			ResourceGroupName: pulumi.String("res3376"),
 * 			ShareName:         pulumi.String("share6185"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.FileShare;
 * import com.pulumi.azurenative.storage.FileShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileShare = new FileShare("fileShare", FileShareArgs.builder()
 *             .accountName("sto328")
 *             .resourceGroupName("res3376")
 *             .shareName("share6185")
 *             .build());
 *     }
 * }
 * ```
 * ### PutShares with Access Tier
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fileShare = new AzureNative.Storage.FileShare("fileShare", new()
 *     {
 *         AccessTier = "Hot",
 *         AccountName = "sto666",
 *         ResourceGroupName = "res346",
 *         ShareName = "share1235",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewFileShare(ctx, "fileShare", &storage.FileShareArgs{
 * 			AccessTier:        pulumi.String("Hot"),
 * 			AccountName:       pulumi.String("sto666"),
 * 			ResourceGroupName: pulumi.String("res346"),
 * 			ShareName:         pulumi.String("share1235"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.FileShare;
 * import com.pulumi.azurenative.storage.FileShareArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fileShare = new FileShare("fileShare", FileShareArgs.builder()
 *             .accessTier("Hot")
 *             .accountName("sto666")
 *             .resourceGroupName("res346")
 *             .shareName("share1235")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:FileShare share1235 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/fileServices/default/shares/{shareName}
 * ```
 * @property accessTier Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium.
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property enabledProtocols The authentication protocol that is used for the file share. Can only be specified when creating a share.
 * @property expand Optional, used to expand the properties within share's properties. Valid values are: snapshots. Should be passed as a string with delimiter ','
 * @property metadata A name-value pair to associate with the share as metadata.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property rootSquash The property is for NFS share only. The default is NoRootSquash.
 * @property shareName The name of the file share within the specified storage account. File share names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
 * @property shareQuota The maximum size of the share, in gigabytes. Must be greater than 0, and less than or equal to 5TB (5120). For Large File Shares, the maximum size is 102400.
 * @property signedIdentifiers List of stored access policies specified on the share.
 */
public data class FileShareArgs(
    public val accessTier: Output<Either<String, ShareAccessTier>>? = null,
    public val accountName: Output<String>? = null,
    public val enabledProtocols: Output<Either<String, EnabledProtocols>>? = null,
    public val expand: Output<String>? = null,
    public val metadata: Output<Map<String, String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rootSquash: Output<Either<String, RootSquashType>>? = null,
    public val shareName: Output<String>? = null,
    public val shareQuota: Output<Int>? = null,
    public val signedIdentifiers: Output<List<SignedIdentifierArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.FileShareArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.FileShareArgs =
        com.pulumi.azurenative.storage.FileShareArgs.builder()
            .accessTier(
                accessTier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .enabledProtocols(
                enabledProtocols?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .expand(expand?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rootSquash(
                rootSquash?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .shareName(shareName?.applyValue({ args0 -> args0 }))
            .shareQuota(shareQuota?.applyValue({ args0 -> args0 }))
            .signedIdentifiers(
                signedIdentifiers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FileShareArgs].
 */
@PulumiTagMarker
public class FileShareArgsBuilder internal constructor() {
    private var accessTier: Output<Either<String, ShareAccessTier>>? = null

    private var accountName: Output<String>? = null

    private var enabledProtocols: Output<Either<String, EnabledProtocols>>? = null

    private var expand: Output<String>? = null

    private var metadata: Output<Map<String, String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var rootSquash: Output<Either<String, RootSquashType>>? = null

    private var shareName: Output<String>? = null

    private var shareQuota: Output<Int>? = null

    private var signedIdentifiers: Output<List<SignedIdentifierArgs>>? = null

    /**
     * @param value Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium.
     */
    @JvmName("sljkhfbawdhxcupk")
    public suspend fun accessTier(`value`: Output<Either<String, ShareAccessTier>>) {
        this.accessTier = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("pxtsekpfxcptykvk")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value The authentication protocol that is used for the file share. Can only be specified when creating a share.
     */
    @JvmName("nwkygmxgsfetpasw")
    public suspend fun enabledProtocols(`value`: Output<Either<String, EnabledProtocols>>) {
        this.enabledProtocols = value
    }

    /**
     * @param value Optional, used to expand the properties within share's properties. Valid values are: snapshots. Should be passed as a string with delimiter ','
     */
    @JvmName("dlxoloqrclfqdttt")
    public suspend fun expand(`value`: Output<String>) {
        this.expand = value
    }

    /**
     * @param value A name-value pair to associate with the share as metadata.
     */
    @JvmName("avwuvcjgmemmorry")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("gsijmqbkbwwghjww")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The property is for NFS share only. The default is NoRootSquash.
     */
    @JvmName("rpasfqjbwjuumacc")
    public suspend fun rootSquash(`value`: Output<Either<String, RootSquashType>>) {
        this.rootSquash = value
    }

    /**
     * @param value The name of the file share within the specified storage account. File share names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     */
    @JvmName("vdschpivhhwfjfyu")
    public suspend fun shareName(`value`: Output<String>) {
        this.shareName = value
    }

    /**
     * @param value The maximum size of the share, in gigabytes. Must be greater than 0, and less than or equal to 5TB (5120). For Large File Shares, the maximum size is 102400.
     */
    @JvmName("cpwiilpcksdhflhm")
    public suspend fun shareQuota(`value`: Output<Int>) {
        this.shareQuota = value
    }

    /**
     * @param value List of stored access policies specified on the share.
     */
    @JvmName("uatudyaqcrkyglfc")
    public suspend fun signedIdentifiers(`value`: Output<List<SignedIdentifierArgs>>) {
        this.signedIdentifiers = value
    }

    @JvmName("narlfyhqqfmqbqav")
    public suspend fun signedIdentifiers(vararg values: Output<SignedIdentifierArgs>) {
        this.signedIdentifiers = Output.all(values.asList())
    }

    /**
     * @param values List of stored access policies specified on the share.
     */
    @JvmName("fethnqdstmsjgmpx")
    public suspend fun signedIdentifiers(values: List<Output<SignedIdentifierArgs>>) {
        this.signedIdentifiers = Output.all(values)
    }

    /**
     * @param value Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium.
     */
    @JvmName("stoadcmmywiojuis")
    public suspend fun accessTier(`value`: Either<String, ShareAccessTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessTier = mapped
    }

    /**
     * @param value Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium.
     */
    @JvmName("xnmuwprioljpqkip")
    public fun accessTier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ShareAccessTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessTier = mapped
    }

    /**
     * @param value Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium.
     */
    @JvmName("cjgfolifmglmnmhi")
    public fun accessTier(`value`: ShareAccessTier) {
        val toBeMapped = Either.ofRight<String, ShareAccessTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessTier = mapped
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("hjcytjarnokiprry")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value The authentication protocol that is used for the file share. Can only be specified when creating a share.
     */
    @JvmName("jauhavavdoqavjol")
    public suspend fun enabledProtocols(`value`: Either<String, EnabledProtocols>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledProtocols = mapped
    }

    /**
     * @param value The authentication protocol that is used for the file share. Can only be specified when creating a share.
     */
    @JvmName("iaqahkxbfbgygniw")
    public fun enabledProtocols(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnabledProtocols>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledProtocols = mapped
    }

    /**
     * @param value The authentication protocol that is used for the file share. Can only be specified when creating a share.
     */
    @JvmName("fuohquefrujxfaqd")
    public fun enabledProtocols(`value`: EnabledProtocols) {
        val toBeMapped = Either.ofRight<String, EnabledProtocols>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledProtocols = mapped
    }

    /**
     * @param value Optional, used to expand the properties within share's properties. Valid values are: snapshots. Should be passed as a string with delimiter ','
     */
    @JvmName("csfktamnqdveyaad")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expand = mapped
    }

    /**
     * @param value A name-value pair to associate with the share as metadata.
     */
    @JvmName("nlsugjlnikecaxgd")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values A name-value pair to associate with the share as metadata.
     */
    @JvmName("ujxdkxoalksjrmtd")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("aamfisunkwncuvca")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The property is for NFS share only. The default is NoRootSquash.
     */
    @JvmName("inolhlovtcoeprih")
    public suspend fun rootSquash(`value`: Either<String, RootSquashType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootSquash = mapped
    }

    /**
     * @param value The property is for NFS share only. The default is NoRootSquash.
     */
    @JvmName("eyhtbwoysmkxxhwk")
    public fun rootSquash(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RootSquashType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rootSquash = mapped
    }

    /**
     * @param value The property is for NFS share only. The default is NoRootSquash.
     */
    @JvmName("naaqlstmqgstdsxt")
    public fun rootSquash(`value`: RootSquashType) {
        val toBeMapped = Either.ofRight<String, RootSquashType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rootSquash = mapped
    }

    /**
     * @param value The name of the file share within the specified storage account. File share names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     */
    @JvmName("oboabhsapexibopd")
    public suspend fun shareName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareName = mapped
    }

    /**
     * @param value The maximum size of the share, in gigabytes. Must be greater than 0, and less than or equal to 5TB (5120). For Large File Shares, the maximum size is 102400.
     */
    @JvmName("mktdwuqcakxtbrox")
    public suspend fun shareQuota(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shareQuota = mapped
    }

    /**
     * @param value List of stored access policies specified on the share.
     */
    @JvmName("cxnhtmmhupbkxaox")
    public suspend fun signedIdentifiers(`value`: List<SignedIdentifierArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.signedIdentifiers = mapped
    }

    /**
     * @param argument List of stored access policies specified on the share.
     */
    @JvmName("jefrgmjiqwwexlfl")
    public suspend
    fun signedIdentifiers(argument: List<suspend SignedIdentifierArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SignedIdentifierArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.signedIdentifiers = mapped
    }

    /**
     * @param argument List of stored access policies specified on the share.
     */
    @JvmName("mkatysxxfmwaiivg")
    public suspend fun signedIdentifiers(
        vararg
        argument: suspend SignedIdentifierArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SignedIdentifierArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.signedIdentifiers = mapped
    }

    /**
     * @param argument List of stored access policies specified on the share.
     */
    @JvmName("ytbusoysbpenqkag")
    public suspend fun signedIdentifiers(argument: suspend SignedIdentifierArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SignedIdentifierArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.signedIdentifiers = mapped
    }

    /**
     * @param values List of stored access policies specified on the share.
     */
    @JvmName("oimwfttbfffmrufr")
    public suspend fun signedIdentifiers(vararg values: SignedIdentifierArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.signedIdentifiers = mapped
    }

    internal fun build(): FileShareArgs = FileShareArgs(
        accessTier = accessTier,
        accountName = accountName,
        enabledProtocols = enabledProtocols,
        expand = expand,
        metadata = metadata,
        resourceGroupName = resourceGroupName,
        rootSquash = rootSquash,
        shareName = shareName,
        shareQuota = shareQuota,
        signedIdentifiers = signedIdentifiers,
    )
}
