@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.LocalUserArgs.builder
import com.pulumi.azurenative.storage.kotlin.inputs.PermissionScopeArgs
import com.pulumi.azurenative.storage.kotlin.inputs.PermissionScopeArgsBuilder
import com.pulumi.azurenative.storage.kotlin.inputs.SshPublicKeyArgs
import com.pulumi.azurenative.storage.kotlin.inputs.SshPublicKeyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The local user associated with the storage accounts.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-08-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### CreateLocalUser
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var localUser = new AzureNative.Storage.LocalUser("localUser", new()
 *     {
 *         AccountName = "sto2527",
 *         HasSshPassword = true,
 *         HomeDirectory = "homedirectory",
 *         PermissionScopes = new[]
 *         {
 *             new AzureNative.Storage.Inputs.PermissionScopeArgs
 *             {
 *                 Permissions = "rwd",
 *                 ResourceName = "share1",
 *                 Service = "file",
 *             },
 *             new AzureNative.Storage.Inputs.PermissionScopeArgs
 *             {
 *                 Permissions = "rw",
 *                 ResourceName = "share2",
 *                 Service = "file",
 *             },
 *         },
 *         ResourceGroupName = "res6977",
 *         SshAuthorizedKeys = new[]
 *         {
 *             new AzureNative.Storage.Inputs.SshPublicKeyArgs
 *             {
 *                 Description = "key name",
 *                 Key = "ssh-rsa keykeykeykeykey=",
 *             },
 *         },
 *         Username = "user1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewLocalUser(ctx, "localUser", &storage.LocalUserArgs{
 * 			AccountName:    pulumi.String("sto2527"),
 * 			HasSshPassword: pulumi.Bool(true),
 * 			HomeDirectory:  pulumi.String("homedirectory"),
 * 			PermissionScopes: []storage.PermissionScopeArgs{
 * 				{
 * 					Permissions:  pulumi.String("rwd"),
 * 					ResourceName: pulumi.String("share1"),
 * 					Service:      pulumi.String("file"),
 * 				},
 * 				{
 * 					Permissions:  pulumi.String("rw"),
 * 					ResourceName: pulumi.String("share2"),
 * 					Service:      pulumi.String("file"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("res6977"),
 * 			SshAuthorizedKeys: []storage.SshPublicKeyArgs{
 * 				{
 * 					Description: pulumi.String("key name"),
 * 					Key:         pulumi.String("ssh-rsa keykeykeykeykey="),
 * 				},
 * 			},
 * 			Username: pulumi.String("user1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.LocalUser;
 * import com.pulumi.azurenative.storage.LocalUserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var localUser = new LocalUser("localUser", LocalUserArgs.builder()
 *             .accountName("sto2527")
 *             .hasSshPassword(true)
 *             .homeDirectory("homedirectory")
 *             .permissionScopes(
 *                 Map.ofEntries(
 *                     Map.entry("permissions", "rwd"),
 *                     Map.entry("resourceName", "share1"),
 *                     Map.entry("service", "file")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("permissions", "rw"),
 *                     Map.entry("resourceName", "share2"),
 *                     Map.entry("service", "file")
 *                 ))
 *             .resourceGroupName("res6977")
 *             .sshAuthorizedKeys(Map.ofEntries(
 *                 Map.entry("description", "key name"),
 *                 Map.entry("key", "ssh-rsa keykeykeykeykey=")
 *             ))
 *             .username("user1")
 *             .build());
 *     }
 * }
 * ```
 * ### UpdateLocalUser
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var localUser = new AzureNative.Storage.LocalUser("localUser", new()
 *     {
 *         AccountName = "sto2527",
 *         HasSharedKey = false,
 *         HasSshKey = false,
 *         HasSshPassword = false,
 *         HomeDirectory = "homedirectory2",
 *         ResourceGroupName = "res6977",
 *         Username = "user1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewLocalUser(ctx, "localUser", &storage.LocalUserArgs{
 * 			AccountName:       pulumi.String("sto2527"),
 * 			HasSharedKey:      pulumi.Bool(false),
 * 			HasSshKey:         pulumi.Bool(false),
 * 			HasSshPassword:    pulumi.Bool(false),
 * 			HomeDirectory:     pulumi.String("homedirectory2"),
 * 			ResourceGroupName: pulumi.String("res6977"),
 * 			Username:          pulumi.String("user1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.LocalUser;
 * import com.pulumi.azurenative.storage.LocalUserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var localUser = new LocalUser("localUser", LocalUserArgs.builder()
 *             .accountName("sto2527")
 *             .hasSharedKey(false)
 *             .hasSshKey(false)
 *             .hasSshPassword(false)
 *             .homeDirectory("homedirectory2")
 *             .resourceGroupName("res6977")
 *             .username("user1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:LocalUser user1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/localUsers/{username}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property hasSharedKey Indicates whether shared key exists. Set it to false to remove existing shared key.
 * @property hasSshKey Indicates whether ssh key exists. Set it to false to remove existing SSH key.
 * @property hasSshPassword Indicates whether ssh password exists. Set it to false to remove existing SSH password.
 * @property homeDirectory Optional, local user home directory.
 * @property permissionScopes The permission scopes of the local user.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property sshAuthorizedKeys Optional, local user ssh authorized keys for SFTP.
 * @property username The name of local user. The username must contain lowercase letters and numbers only. It must be unique only within the storage account.
 */
public data class LocalUserArgs(
    public val accountName: Output<String>? = null,
    public val hasSharedKey: Output<Boolean>? = null,
    public val hasSshKey: Output<Boolean>? = null,
    public val hasSshPassword: Output<Boolean>? = null,
    public val homeDirectory: Output<String>? = null,
    public val permissionScopes: Output<List<PermissionScopeArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sshAuthorizedKeys: Output<List<SshPublicKeyArgs>>? = null,
    public val username: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.LocalUserArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.LocalUserArgs =
        com.pulumi.azurenative.storage.LocalUserArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .hasSharedKey(hasSharedKey?.applyValue({ args0 -> args0 }))
            .hasSshKey(hasSshKey?.applyValue({ args0 -> args0 }))
            .hasSshPassword(hasSshPassword?.applyValue({ args0 -> args0 }))
            .homeDirectory(homeDirectory?.applyValue({ args0 -> args0 }))
            .permissionScopes(
                permissionScopes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sshAuthorizedKeys(
                sshAuthorizedKeys?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .username(username?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LocalUserArgs].
 */
@PulumiTagMarker
public class LocalUserArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var hasSharedKey: Output<Boolean>? = null

    private var hasSshKey: Output<Boolean>? = null

    private var hasSshPassword: Output<Boolean>? = null

    private var homeDirectory: Output<String>? = null

    private var permissionScopes: Output<List<PermissionScopeArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sshAuthorizedKeys: Output<List<SshPublicKeyArgs>>? = null

    private var username: Output<String>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("rxmkijtgecohpmxo")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Indicates whether shared key exists. Set it to false to remove existing shared key.
     */
    @JvmName("tbnwoumritgtdqpo")
    public suspend fun hasSharedKey(`value`: Output<Boolean>) {
        this.hasSharedKey = value
    }

    /**
     * @param value Indicates whether ssh key exists. Set it to false to remove existing SSH key.
     */
    @JvmName("sruvagwndbrysajc")
    public suspend fun hasSshKey(`value`: Output<Boolean>) {
        this.hasSshKey = value
    }

    /**
     * @param value Indicates whether ssh password exists. Set it to false to remove existing SSH password.
     */
    @JvmName("ewdbqopvqnsqlych")
    public suspend fun hasSshPassword(`value`: Output<Boolean>) {
        this.hasSshPassword = value
    }

    /**
     * @param value Optional, local user home directory.
     */
    @JvmName("pufqedxgiucvebum")
    public suspend fun homeDirectory(`value`: Output<String>) {
        this.homeDirectory = value
    }

    /**
     * @param value The permission scopes of the local user.
     */
    @JvmName("isbiyxdwwnfeuclb")
    public suspend fun permissionScopes(`value`: Output<List<PermissionScopeArgs>>) {
        this.permissionScopes = value
    }

    @JvmName("wruomgieydqdqwrh")
    public suspend fun permissionScopes(vararg values: Output<PermissionScopeArgs>) {
        this.permissionScopes = Output.all(values.asList())
    }

    /**
     * @param values The permission scopes of the local user.
     */
    @JvmName("cumjdiuqruhhlohn")
    public suspend fun permissionScopes(values: List<Output<PermissionScopeArgs>>) {
        this.permissionScopes = Output.all(values)
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("tsohqkvyjxjwlboe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Optional, local user ssh authorized keys for SFTP.
     */
    @JvmName("nduiksjrrdyrhfiv")
    public suspend fun sshAuthorizedKeys(`value`: Output<List<SshPublicKeyArgs>>) {
        this.sshAuthorizedKeys = value
    }

    @JvmName("iswbvxtckxitochr")
    public suspend fun sshAuthorizedKeys(vararg values: Output<SshPublicKeyArgs>) {
        this.sshAuthorizedKeys = Output.all(values.asList())
    }

    /**
     * @param values Optional, local user ssh authorized keys for SFTP.
     */
    @JvmName("yhwqeoclsaqsqfij")
    public suspend fun sshAuthorizedKeys(values: List<Output<SshPublicKeyArgs>>) {
        this.sshAuthorizedKeys = Output.all(values)
    }

    /**
     * @param value The name of local user. The username must contain lowercase letters and numbers only. It must be unique only within the storage account.
     */
    @JvmName("pcwkxrumycryavcx")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("udsyxephvwofhciy")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Indicates whether shared key exists. Set it to false to remove existing shared key.
     */
    @JvmName("anvvcddlcrwaybfj")
    public suspend fun hasSharedKey(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hasSharedKey = mapped
    }

    /**
     * @param value Indicates whether ssh key exists. Set it to false to remove existing SSH key.
     */
    @JvmName("ysybdbpaftespjxx")
    public suspend fun hasSshKey(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hasSshKey = mapped
    }

    /**
     * @param value Indicates whether ssh password exists. Set it to false to remove existing SSH password.
     */
    @JvmName("fceodmrxirbepgtw")
    public suspend fun hasSshPassword(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hasSshPassword = mapped
    }

    /**
     * @param value Optional, local user home directory.
     */
    @JvmName("kocrqlkpditgbeot")
    public suspend fun homeDirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.homeDirectory = mapped
    }

    /**
     * @param value The permission scopes of the local user.
     */
    @JvmName("vymxyckcrsxmhhes")
    public suspend fun permissionScopes(`value`: List<PermissionScopeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissionScopes = mapped
    }

    /**
     * @param argument The permission scopes of the local user.
     */
    @JvmName("avqqtsfpalmdigse")
    public suspend
    fun permissionScopes(argument: List<suspend PermissionScopeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PermissionScopeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissionScopes = mapped
    }

    /**
     * @param argument The permission scopes of the local user.
     */
    @JvmName("ypragqvximinxwqq")
    public suspend fun permissionScopes(
        vararg
        argument: suspend PermissionScopeArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            PermissionScopeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissionScopes = mapped
    }

    /**
     * @param argument The permission scopes of the local user.
     */
    @JvmName("srefkgqbtkekvrfv")
    public suspend fun permissionScopes(argument: suspend PermissionScopeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PermissionScopeArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.permissionScopes = mapped
    }

    /**
     * @param values The permission scopes of the local user.
     */
    @JvmName("cmbsmajijceacatn")
    public suspend fun permissionScopes(vararg values: PermissionScopeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissionScopes = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("kongefvocnpxhmgy")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Optional, local user ssh authorized keys for SFTP.
     */
    @JvmName("hdfuersvogmmjelc")
    public suspend fun sshAuthorizedKeys(`value`: List<SshPublicKeyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshAuthorizedKeys = mapped
    }

    /**
     * @param argument Optional, local user ssh authorized keys for SFTP.
     */
    @JvmName("meiaasgptabhvrbc")
    public suspend fun sshAuthorizedKeys(argument: List<suspend SshPublicKeyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SshPublicKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sshAuthorizedKeys = mapped
    }

    /**
     * @param argument Optional, local user ssh authorized keys for SFTP.
     */
    @JvmName("vmwmjonkikinudyx")
    public suspend fun sshAuthorizedKeys(
        vararg
        argument: suspend SshPublicKeyArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            SshPublicKeyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.sshAuthorizedKeys = mapped
    }

    /**
     * @param argument Optional, local user ssh authorized keys for SFTP.
     */
    @JvmName("nxskhkdhqpgxbwsb")
    public suspend fun sshAuthorizedKeys(argument: suspend SshPublicKeyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SshPublicKeyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sshAuthorizedKeys = mapped
    }

    /**
     * @param values Optional, local user ssh authorized keys for SFTP.
     */
    @JvmName("kibogisawkbdttmq")
    public suspend fun sshAuthorizedKeys(vararg values: SshPublicKeyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sshAuthorizedKeys = mapped
    }

    /**
     * @param value The name of local user. The username must contain lowercase letters and numbers only. It must be unique only within the storage account.
     */
    @JvmName("peybeciijhoxrpjr")
    public suspend fun username(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): LocalUserArgs = LocalUserArgs(
        accountName = accountName,
        hasSharedKey = hasSharedKey,
        hasSshKey = hasSshKey,
        hasSshPassword = hasSshPassword,
        homeDirectory = homeDirectory,
        permissionScopes = permissionScopes,
        resourceGroupName = resourceGroupName,
        sshAuthorizedKeys = sshAuthorizedKeys,
        username = username,
    )
}
