@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.azurenative.storage.ObjectReplicationPolicyArgs.builder
import com.pulumi.azurenative.storage.kotlin.inputs.ObjectReplicationPolicyRuleArgs
import com.pulumi.azurenative.storage.kotlin.inputs.ObjectReplicationPolicyRuleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The replication policy between two storage accounts. Multiple rules can be defined in one policy.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### StorageAccountCreateObjectReplicationPolicyOnDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var objectReplicationPolicy = new AzureNative.Storage.ObjectReplicationPolicy("objectReplicationPolicy", new()
 *     {
 *         AccountName = "dst112",
 *         DestinationAccount = "dst112",
 *         ObjectReplicationPolicyId = "default",
 *         ResourceGroupName = "res7687",
 *         Rules = new[]
 *         {
 *             new AzureNative.Storage.Inputs.ObjectReplicationPolicyRuleArgs
 *             {
 *                 DestinationContainer = "dcont139",
 *                 Filters = new AzureNative.Storage.Inputs.ObjectReplicationPolicyFilterArgs
 *                 {
 *                     PrefixMatch = new[]
 *                     {
 *                         "blobA",
 *                         "blobB",
 *                     },
 *                 },
 *                 SourceContainer = "scont139",
 *             },
 *         },
 *         SourceAccount = "src1122",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewObjectReplicationPolicy(ctx, "objectReplicationPolicy", &storage.ObjectReplicationPolicyArgs{
 * 			AccountName:               pulumi.String("dst112"),
 * 			DestinationAccount:        pulumi.String("dst112"),
 * 			ObjectReplicationPolicyId: pulumi.String("default"),
 * 			ResourceGroupName:         pulumi.String("res7687"),
 * 			Rules: []storage.ObjectReplicationPolicyRuleArgs{
 * 				{
 * 					DestinationContainer: pulumi.String("dcont139"),
 * 					Filters: {
 * 						PrefixMatch: pulumi.StringArray{
 * 							pulumi.String("blobA"),
 * 							pulumi.String("blobB"),
 * 						},
 * 					},
 * 					SourceContainer: pulumi.String("scont139"),
 * 				},
 * 			},
 * 			SourceAccount: pulumi.String("src1122"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicy;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var objectReplicationPolicy = new ObjectReplicationPolicy("objectReplicationPolicy", ObjectReplicationPolicyArgs.builder()
 *             .accountName("dst112")
 *             .destinationAccount("dst112")
 *             .objectReplicationPolicyId("default")
 *             .resourceGroupName("res7687")
 *             .rules(Map.ofEntries(
 *                 Map.entry("destinationContainer", "dcont139"),
 *                 Map.entry("filters", Map.of("prefixMatch",
 *                     "blobA",
 *                     "blobB")),
 *                 Map.entry("sourceContainer", "scont139")
 *             ))
 *             .sourceAccount("src1122")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountCreateObjectReplicationPolicyOnSource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var objectReplicationPolicy = new AzureNative.Storage.ObjectReplicationPolicy("objectReplicationPolicy", new()
 *     {
 *         AccountName = "src1122",
 *         DestinationAccount = "dst112",
 *         ObjectReplicationPolicyId = "2a20bb73-5717-4635-985a-5d4cf777438f",
 *         ResourceGroupName = "res7687",
 *         Rules = new[]
 *         {
 *             new AzureNative.Storage.Inputs.ObjectReplicationPolicyRuleArgs
 *             {
 *                 DestinationContainer = "dcont139",
 *                 Filters = new AzureNative.Storage.Inputs.ObjectReplicationPolicyFilterArgs
 *                 {
 *                     MinCreationTime = "2020-02-19T16:05:00Z",
 *                     PrefixMatch = new[]
 *                     {
 *                         "blobA",
 *                         "blobB",
 *                     },
 *                 },
 *                 RuleId = "d5d18a48-8801-4554-aeaa-74faf65f5ef9",
 *                 SourceContainer = "scont139",
 *             },
 *         },
 *         SourceAccount = "src1122",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewObjectReplicationPolicy(ctx, "objectReplicationPolicy", &storage.ObjectReplicationPolicyArgs{
 * 			AccountName:               pulumi.String("src1122"),
 * 			DestinationAccount:        pulumi.String("dst112"),
 * 			ObjectReplicationPolicyId: pulumi.String("2a20bb73-5717-4635-985a-5d4cf777438f"),
 * 			ResourceGroupName:         pulumi.String("res7687"),
 * 			Rules: []storage.ObjectReplicationPolicyRuleArgs{
 * 				{
 * 					DestinationContainer: pulumi.String("dcont139"),
 * 					Filters: {
 * 						MinCreationTime: pulumi.String("2020-02-19T16:05:00Z"),
 * 						PrefixMatch: pulumi.StringArray{
 * 							pulumi.String("blobA"),
 * 							pulumi.String("blobB"),
 * 						},
 * 					},
 * 					RuleId:          pulumi.String("d5d18a48-8801-4554-aeaa-74faf65f5ef9"),
 * 					SourceContainer: pulumi.String("scont139"),
 * 				},
 * 			},
 * 			SourceAccount: pulumi.String("src1122"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicy;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var objectReplicationPolicy = new ObjectReplicationPolicy("objectReplicationPolicy", ObjectReplicationPolicyArgs.builder()
 *             .accountName("src1122")
 *             .destinationAccount("dst112")
 *             .objectReplicationPolicyId("2a20bb73-5717-4635-985a-5d4cf777438f")
 *             .resourceGroupName("res7687")
 *             .rules(Map.ofEntries(
 *                 Map.entry("destinationContainer", "dcont139"),
 *                 Map.entry("filters", Map.ofEntries(
 *                     Map.entry("minCreationTime", "2020-02-19T16:05:00Z"),
 *                     Map.entry("prefixMatch",
 *                         "blobA",
 *                         "blobB")
 *                 )),
 *                 Map.entry("ruleId", "d5d18a48-8801-4554-aeaa-74faf65f5ef9"),
 *                 Map.entry("sourceContainer", "scont139")
 *             ))
 *             .sourceAccount("src1122")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountUpdateObjectReplicationPolicyOnDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var objectReplicationPolicy = new AzureNative.Storage.ObjectReplicationPolicy("objectReplicationPolicy", new()
 *     {
 *         AccountName = "dst112",
 *         DestinationAccount = "dst112",
 *         ObjectReplicationPolicyId = "2a20bb73-5717-4635-985a-5d4cf777438f",
 *         ResourceGroupName = "res7687",
 *         Rules = new[]
 *         {
 *             new AzureNative.Storage.Inputs.ObjectReplicationPolicyRuleArgs
 *             {
 *                 DestinationContainer = "dcont139",
 *                 Filters = new AzureNative.Storage.Inputs.ObjectReplicationPolicyFilterArgs
 *                 {
 *                     PrefixMatch = new[]
 *                     {
 *                         "blobA",
 *                         "blobB",
 *                     },
 *                 },
 *                 RuleId = "d5d18a48-8801-4554-aeaa-74faf65f5ef9",
 *                 SourceContainer = "scont139",
 *             },
 *             new AzureNative.Storage.Inputs.ObjectReplicationPolicyRuleArgs
 *             {
 *                 DestinationContainer = "dcont179",
 *                 SourceContainer = "scont179",
 *             },
 *         },
 *         SourceAccount = "src1122",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewObjectReplicationPolicy(ctx, "objectReplicationPolicy", &storage.ObjectReplicationPolicyArgs{
 * 			AccountName:               pulumi.String("dst112"),
 * 			DestinationAccount:        pulumi.String("dst112"),
 * 			ObjectReplicationPolicyId: pulumi.String("2a20bb73-5717-4635-985a-5d4cf777438f"),
 * 			ResourceGroupName:         pulumi.String("res7687"),
 * 			Rules: []storage.ObjectReplicationPolicyRuleArgs{
 * 				{
 * 					DestinationContainer: pulumi.String("dcont139"),
 * 					Filters: {
 * 						PrefixMatch: pulumi.StringArray{
 * 							pulumi.String("blobA"),
 * 							pulumi.String("blobB"),
 * 						},
 * 					},
 * 					RuleId:          pulumi.String("d5d18a48-8801-4554-aeaa-74faf65f5ef9"),
 * 					SourceContainer: pulumi.String("scont139"),
 * 				},
 * 				{
 * 					DestinationContainer: pulumi.String("dcont179"),
 * 					SourceContainer:      pulumi.String("scont179"),
 * 				},
 * 			},
 * 			SourceAccount: pulumi.String("src1122"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicy;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var objectReplicationPolicy = new ObjectReplicationPolicy("objectReplicationPolicy", ObjectReplicationPolicyArgs.builder()
 *             .accountName("dst112")
 *             .destinationAccount("dst112")
 *             .objectReplicationPolicyId("2a20bb73-5717-4635-985a-5d4cf777438f")
 *             .resourceGroupName("res7687")
 *             .rules(
 *                 Map.ofEntries(
 *                     Map.entry("destinationContainer", "dcont139"),
 *                     Map.entry("filters", Map.of("prefixMatch",
 *                         "blobA",
 *                         "blobB")),
 *                     Map.entry("ruleId", "d5d18a48-8801-4554-aeaa-74faf65f5ef9"),
 *                     Map.entry("sourceContainer", "scont139")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("destinationContainer", "dcont179"),
 *                     Map.entry("sourceContainer", "scont179")
 *                 ))
 *             .sourceAccount("src1122")
 *             .build());
 *     }
 * }
 * ```
 * ### StorageAccountUpdateObjectReplicationPolicyOnSource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var objectReplicationPolicy = new AzureNative.Storage.ObjectReplicationPolicy("objectReplicationPolicy", new()
 *     {
 *         AccountName = "src1122",
 *         DestinationAccount = "dst112",
 *         ObjectReplicationPolicyId = "2a20bb73-5717-4635-985a-5d4cf777438f",
 *         ResourceGroupName = "res7687",
 *         Rules = new[]
 *         {
 *             new AzureNative.Storage.Inputs.ObjectReplicationPolicyRuleArgs
 *             {
 *                 DestinationContainer = "dcont139",
 *                 Filters = new AzureNative.Storage.Inputs.ObjectReplicationPolicyFilterArgs
 *                 {
 *                     PrefixMatch = new[]
 *                     {
 *                         "blobA",
 *                         "blobB",
 *                     },
 *                 },
 *                 RuleId = "d5d18a48-8801-4554-aeaa-74faf65f5ef9",
 *                 SourceContainer = "scont139",
 *             },
 *             new AzureNative.Storage.Inputs.ObjectReplicationPolicyRuleArgs
 *             {
 *                 DestinationContainer = "dcont179",
 *                 RuleId = "cfbb4bc2-8b60-429f-b05a-d1e0942b33b2",
 *                 SourceContainer = "scont179",
 *             },
 *         },
 *         SourceAccount = "src1122",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewObjectReplicationPolicy(ctx, "objectReplicationPolicy", &storage.ObjectReplicationPolicyArgs{
 * 			AccountName:               pulumi.String("src1122"),
 * 			DestinationAccount:        pulumi.String("dst112"),
 * 			ObjectReplicationPolicyId: pulumi.String("2a20bb73-5717-4635-985a-5d4cf777438f"),
 * 			ResourceGroupName:         pulumi.String("res7687"),
 * 			Rules: []storage.ObjectReplicationPolicyRuleArgs{
 * 				{
 * 					DestinationContainer: pulumi.String("dcont139"),
 * 					Filters: {
 * 						PrefixMatch: pulumi.StringArray{
 * 							pulumi.String("blobA"),
 * 							pulumi.String("blobB"),
 * 						},
 * 					},
 * 					RuleId:          pulumi.String("d5d18a48-8801-4554-aeaa-74faf65f5ef9"),
 * 					SourceContainer: pulumi.String("scont139"),
 * 				},
 * 				{
 * 					DestinationContainer: pulumi.String("dcont179"),
 * 					RuleId:               pulumi.String("cfbb4bc2-8b60-429f-b05a-d1e0942b33b2"),
 * 					SourceContainer:      pulumi.String("scont179"),
 * 				},
 * 			},
 * 			SourceAccount: pulumi.String("src1122"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicy;
 * import com.pulumi.azurenative.storage.ObjectReplicationPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var objectReplicationPolicy = new ObjectReplicationPolicy("objectReplicationPolicy", ObjectReplicationPolicyArgs.builder()
 *             .accountName("src1122")
 *             .destinationAccount("dst112")
 *             .objectReplicationPolicyId("2a20bb73-5717-4635-985a-5d4cf777438f")
 *             .resourceGroupName("res7687")
 *             .rules(
 *                 Map.ofEntries(
 *                     Map.entry("destinationContainer", "dcont139"),
 *                     Map.entry("filters", Map.of("prefixMatch",
 *                         "blobA",
 *                         "blobB")),
 *                     Map.entry("ruleId", "d5d18a48-8801-4554-aeaa-74faf65f5ef9"),
 *                     Map.entry("sourceContainer", "scont139")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("destinationContainer", "dcont179"),
 *                     Map.entry("ruleId", "cfbb4bc2-8b60-429f-b05a-d1e0942b33b2"),
 *                     Map.entry("sourceContainer", "scont179")
 *                 ))
 *             .sourceAccount("src1122")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:ObjectReplicationPolicy 2a20bb73-5717-4635-985a-5d4cf777438f /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/objectReplicationPolicies/{objectReplicationPolicyId}
 * ```
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property destinationAccount Required. Destination account name. It should be full resource id if allowCrossTenantReplication set to false.
 * @property objectReplicationPolicyId For the destination account, provide the value 'default'. Configure the policy on the destination account first. For the source account, provide the value of the policy ID that is returned when you download the policy that was defined on the destination account. The policy is downloaded as a JSON file.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property rules The storage account object replication rules.
 * @property sourceAccount Required. Source account name. It should be full resource id if allowCrossTenantReplication set to false.
 */
public data class ObjectReplicationPolicyArgs(
    public val accountName: Output<String>? = null,
    public val destinationAccount: Output<String>? = null,
    public val objectReplicationPolicyId: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rules: Output<List<ObjectReplicationPolicyRuleArgs>>? = null,
    public val sourceAccount: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.ObjectReplicationPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.ObjectReplicationPolicyArgs =
        com.pulumi.azurenative.storage.ObjectReplicationPolicyArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .destinationAccount(destinationAccount?.applyValue({ args0 -> args0 }))
            .objectReplicationPolicyId(objectReplicationPolicyId?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .sourceAccount(sourceAccount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ObjectReplicationPolicyArgs].
 */
@PulumiTagMarker
public class ObjectReplicationPolicyArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var destinationAccount: Output<String>? = null

    private var objectReplicationPolicyId: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var rules: Output<List<ObjectReplicationPolicyRuleArgs>>? = null

    private var sourceAccount: Output<String>? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("jlcsabcvrxsbwrab")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Required. Destination account name. It should be full resource id if allowCrossTenantReplication set to false.
     */
    @JvmName("mligpdqoxvvxfldi")
    public suspend fun destinationAccount(`value`: Output<String>) {
        this.destinationAccount = value
    }

    /**
     * @param value For the destination account, provide the value 'default'. Configure the policy on the destination account first. For the source account, provide the value of the policy ID that is returned when you download the policy that was defined on the destination account. The policy is downloaded as a JSON file.
     */
    @JvmName("dccdrnpeuexrfluo")
    public suspend fun objectReplicationPolicyId(`value`: Output<String>) {
        this.objectReplicationPolicyId = value
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("douemehlvhifxnbs")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The storage account object replication rules.
     */
    @JvmName("ptumyncxbjtbcola")
    public suspend fun rules(`value`: Output<List<ObjectReplicationPolicyRuleArgs>>) {
        this.rules = value
    }

    @JvmName("htpeuxcnxqisnkuh")
    public suspend fun rules(vararg values: Output<ObjectReplicationPolicyRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values The storage account object replication rules.
     */
    @JvmName("lkpcosmwtdnwfuoe")
    public suspend fun rules(values: List<Output<ObjectReplicationPolicyRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Required. Source account name. It should be full resource id if allowCrossTenantReplication set to false.
     */
    @JvmName("nqbedmkvpxpelbao")
    public suspend fun sourceAccount(`value`: Output<String>) {
        this.sourceAccount = value
    }

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("pwvmxeqhtwupqpkn")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Required. Destination account name. It should be full resource id if allowCrossTenantReplication set to false.
     */
    @JvmName("ispnwxruvkvhpkob")
    public suspend fun destinationAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationAccount = mapped
    }

    /**
     * @param value For the destination account, provide the value 'default'. Configure the policy on the destination account first. For the source account, provide the value of the policy ID that is returned when you download the policy that was defined on the destination account. The policy is downloaded as a JSON file.
     */
    @JvmName("ubusnutievqvqljg")
    public suspend fun objectReplicationPolicyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectReplicationPolicyId = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("tkyafxcwgabmbmnk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The storage account object replication rules.
     */
    @JvmName("qucitkodooqmoidc")
    public suspend fun rules(`value`: List<ObjectReplicationPolicyRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument The storage account object replication rules.
     */
    @JvmName("xnsidaobfobfrdib")
    public suspend
    fun rules(argument: List<suspend ObjectReplicationPolicyRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ObjectReplicationPolicyRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The storage account object replication rules.
     */
    @JvmName("fyovyhiwdwkwlufv")
    public suspend fun rules(
        vararg
        argument: suspend ObjectReplicationPolicyRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ObjectReplicationPolicyRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument The storage account object replication rules.
     */
    @JvmName("yvxlncfktenmajho")
    public suspend fun rules(argument: suspend ObjectReplicationPolicyRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ObjectReplicationPolicyRuleArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values The storage account object replication rules.
     */
    @JvmName("djylamfpvedjjhmq")
    public suspend fun rules(vararg values: ObjectReplicationPolicyRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param value Required. Source account name. It should be full resource id if allowCrossTenantReplication set to false.
     */
    @JvmName("wxcjrijtsfpollue")
    public suspend fun sourceAccount(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAccount = mapped
    }

    internal fun build(): ObjectReplicationPolicyArgs = ObjectReplicationPolicyArgs(
        accountName = accountName,
        destinationAccount = destinationAccount,
        objectReplicationPolicyId = objectReplicationPolicyId,
        resourceGroupName = resourceGroupName,
        rules = rules,
        sourceAccount = sourceAccount,
    )
}
