@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Queue].
 */
@PulumiTagMarker
public class QueueResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QueueArgs = QueueArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QueueArgsBuilder.() -> Unit) {
        val builder = QueueArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Queue {
        val builtJavaResource = com.pulumi.azurenative.storage.Queue(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Queue(builtJavaResource)
    }
}

/**
 *
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2021-02-01.
 * Other available API versions: 2023-01-01.
 * ## Example Usage
 * ### QueueOperationPut
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queue = new AzureNative.Storage.Queue("queue", new()
 *     {
 *         AccountName = "sto328",
 *         QueueName = "queue6185",
 *         ResourceGroupName = "res3376",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewQueue(ctx, "queue", &storage.QueueArgs{
 * 			AccountName:       pulumi.String("sto328"),
 * 			QueueName:         pulumi.String("queue6185"),
 * 			ResourceGroupName: pulumi.String("res3376"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.Queue;
 * import com.pulumi.azurenative.storage.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue", QueueArgs.builder()
 *             .accountName("sto328")
 *             .queueName("queue6185")
 *             .resourceGroupName("res3376")
 *             .build());
 *     }
 * }
 * ```
 * ### QueueOperationPutWithMetadata
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queue = new AzureNative.Storage.Queue("queue", new()
 *     {
 *         AccountName = "sto328",
 *         Metadata =
 *         {
 *             { "sample1", "meta1" },
 *             { "sample2", "meta2" },
 *         },
 *         QueueName = "queue6185",
 *         ResourceGroupName = "res3376",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/storage/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := storage.NewQueue(ctx, "queue", &storage.QueueArgs{
 * 			AccountName: pulumi.String("sto328"),
 * 			Metadata: pulumi.StringMap{
 * 				"sample1": pulumi.String("meta1"),
 * 				"sample2": pulumi.String("meta2"),
 * 			},
 * 			QueueName:         pulumi.String("queue6185"),
 * 			ResourceGroupName: pulumi.String("res3376"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.storage.Queue;
 * import com.pulumi.azurenative.storage.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue", QueueArgs.builder()
 *             .accountName("sto328")
 *             .metadata(Map.ofEntries(
 *                 Map.entry("sample1", "meta1"),
 *                 Map.entry("sample2", "meta2")
 *             ))
 *             .queueName("queue6185")
 *             .resourceGroupName("res3376")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:storage:Queue queue6185 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Storage/storageAccounts/{accountName}/queueServices/default/queues/{queueName}
 * ```
 */
public class Queue internal constructor(
    override val javaResource: com.pulumi.azurenative.storage.Queue,
) : KotlinCustomResource(javaResource, QueueMapper) {
    /**
     * Integer indicating an approximate number of messages in the queue. This number is not lower than the actual number of messages in the queue, but could be higher.
     */
    public val approximateMessageCount: Output<Int>
        get() = javaResource.approximateMessageCount().applyValue({ args0 -> args0 })

    /**
     * A name-value pair that represents queue metadata.
     */
    public val metadata: Output<Map<String, String>>?
        get() = javaResource.metadata().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object QueueMapper : ResourceMapper<Queue> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.storage.Queue::class == javaResource::class

    override fun map(javaResource: Resource): Queue = Queue(
        javaResource as
            com.pulumi.azurenative.storage.Queue,
    )
}

/**
 * @see [Queue].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Queue].
 */
public suspend fun queue(name: String, block: suspend QueueResourceBuilder.() -> Unit): Queue {
    val builder = QueueResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Queue].
 * @param name The _unique_ name of the resulting resource.
 */
public fun queue(name: String): Queue {
    val builder = QueueResourceBuilder()
    builder.name(name)
    return builder.build()
}
