@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The identity type.
 */
public enum class IdentityType(
    public val javaValue: com.pulumi.azurenative.storage.enums.IdentityType,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.IdentityType> {
    None(com.pulumi.azurenative.storage.enums.IdentityType.None),
    SystemAssigned(com.pulumi.azurenative.storage.enums.IdentityType.SystemAssigned),
    UserAssigned(com.pulumi.azurenative.storage.enums.IdentityType.UserAssigned),
    SystemAssigned_UserAssigned(com.pulumi.azurenative.storage.enums.IdentityType.SystemAssigned_UserAssigned),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.IdentityType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.IdentityType): IdentityType =
            IdentityType.values().first { it.javaValue == javaType }
    }
}
