@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies whether data in the container may be accessed publicly and the level of access.
 */
public enum class PublicAccess(
    public val javaValue: com.pulumi.azurenative.storage.enums.PublicAccess,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.PublicAccess> {
    Container(com.pulumi.azurenative.storage.enums.PublicAccess.Container),
    Blob(com.pulumi.azurenative.storage.enums.PublicAccess.Blob),
    None(com.pulumi.azurenative.storage.enums.PublicAccess.None),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.PublicAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.PublicAccess): PublicAccess =
            PublicAccess.values().first { it.javaValue == javaType }
    }
}
