@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Gets the state of virtual network rule.
 */
public enum class State(
    public val javaValue: com.pulumi.azurenative.storage.enums.State,
) : ConvertibleToJava<com.pulumi.azurenative.storage.enums.State> {
    Provisioning(com.pulumi.azurenative.storage.enums.State.Provisioning),
    Deprovisioning(com.pulumi.azurenative.storage.enums.State.Deprovisioning),
    Succeeded(com.pulumi.azurenative.storage.enums.State.Succeeded),
    Failed(com.pulumi.azurenative.storage.enums.State.Failed),
    NetworkSourceDeleted(com.pulumi.azurenative.storage.enums.State.NetworkSourceDeleted),
    ;

    override fun toJava(): com.pulumi.azurenative.storage.enums.State = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.enums.State): State =
            State.values().first { it.javaValue == javaType }
    }
}
