@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ActiveDirectoryPropertiesArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.AccountType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Settings properties for Active Directory (AD).
 * @property accountType Specifies the Active Directory account type for Azure Storage.
 * @property azureStorageSid Specifies the security identifier (SID) for Azure Storage.
 * @property domainGuid Specifies the domain GUID.
 * @property domainName Specifies the primary domain that the AD DNS server is authoritative for.
 * @property domainSid Specifies the security identifier (SID).
 * @property forestName Specifies the Active Directory forest to get.
 * @property netBiosDomainName Specifies the NetBIOS domain name.
 * @property samAccountName Specifies the Active Directory SAMAccountName for Azure Storage.
 */
public data class ActiveDirectoryPropertiesArgs(
    public val accountType: Output<Either<String, AccountType>>? = null,
    public val azureStorageSid: Output<String>? = null,
    public val domainGuid: Output<String>,
    public val domainName: Output<String>,
    public val domainSid: Output<String>? = null,
    public val forestName: Output<String>? = null,
    public val netBiosDomainName: Output<String>? = null,
    public val samAccountName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ActiveDirectoryPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ActiveDirectoryPropertiesArgs =
        com.pulumi.azurenative.storage.inputs.ActiveDirectoryPropertiesArgs.builder()
            .accountType(
                accountType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .azureStorageSid(azureStorageSid?.applyValue({ args0 -> args0 }))
            .domainGuid(domainGuid.applyValue({ args0 -> args0 }))
            .domainName(domainName.applyValue({ args0 -> args0 }))
            .domainSid(domainSid?.applyValue({ args0 -> args0 }))
            .forestName(forestName?.applyValue({ args0 -> args0 }))
            .netBiosDomainName(netBiosDomainName?.applyValue({ args0 -> args0 }))
            .samAccountName(samAccountName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ActiveDirectoryPropertiesArgs].
 */
@PulumiTagMarker
public class ActiveDirectoryPropertiesArgsBuilder internal constructor() {
    private var accountType: Output<Either<String, AccountType>>? = null

    private var azureStorageSid: Output<String>? = null

    private var domainGuid: Output<String>? = null

    private var domainName: Output<String>? = null

    private var domainSid: Output<String>? = null

    private var forestName: Output<String>? = null

    private var netBiosDomainName: Output<String>? = null

    private var samAccountName: Output<String>? = null

    /**
     * @param value Specifies the Active Directory account type for Azure Storage.
     */
    @JvmName("lqmtchbefoioxvrq")
    public suspend fun accountType(`value`: Output<Either<String, AccountType>>) {
        this.accountType = value
    }

    /**
     * @param value Specifies the security identifier (SID) for Azure Storage.
     */
    @JvmName("tvshlvmcchvjrxyi")
    public suspend fun azureStorageSid(`value`: Output<String>) {
        this.azureStorageSid = value
    }

    /**
     * @param value Specifies the domain GUID.
     */
    @JvmName("qxkbvwqugxwriavu")
    public suspend fun domainGuid(`value`: Output<String>) {
        this.domainGuid = value
    }

    /**
     * @param value Specifies the primary domain that the AD DNS server is authoritative for.
     */
    @JvmName("wjwscqprgjanpymr")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value Specifies the security identifier (SID).
     */
    @JvmName("nyfoylprqbicpoja")
    public suspend fun domainSid(`value`: Output<String>) {
        this.domainSid = value
    }

    /**
     * @param value Specifies the Active Directory forest to get.
     */
    @JvmName("bqskpefmlikfvequ")
    public suspend fun forestName(`value`: Output<String>) {
        this.forestName = value
    }

    /**
     * @param value Specifies the NetBIOS domain name.
     */
    @JvmName("wgadktxhujkelscg")
    public suspend fun netBiosDomainName(`value`: Output<String>) {
        this.netBiosDomainName = value
    }

    /**
     * @param value Specifies the Active Directory SAMAccountName for Azure Storage.
     */
    @JvmName("temmvyowwethxdkv")
    public suspend fun samAccountName(`value`: Output<String>) {
        this.samAccountName = value
    }

    /**
     * @param value Specifies the Active Directory account type for Azure Storage.
     */
    @JvmName("ltdxiwjcwwwqungc")
    public suspend fun accountType(`value`: Either<String, AccountType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountType = mapped
    }

    /**
     * @param value Specifies the Active Directory account type for Azure Storage.
     */
    @JvmName("elseygtomfstqwkb")
    public fun accountType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountType = mapped
    }

    /**
     * @param value Specifies the Active Directory account type for Azure Storage.
     */
    @JvmName("kbsvllthrbcihxse")
    public fun accountType(`value`: AccountType) {
        val toBeMapped = Either.ofRight<String, AccountType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountType = mapped
    }

    /**
     * @param value Specifies the security identifier (SID) for Azure Storage.
     */
    @JvmName("hfrcuyvmmevolgue")
    public suspend fun azureStorageSid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureStorageSid = mapped
    }

    /**
     * @param value Specifies the domain GUID.
     */
    @JvmName("dyqlygwpqipljynf")
    public suspend fun domainGuid(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainGuid = mapped
    }

    /**
     * @param value Specifies the primary domain that the AD DNS server is authoritative for.
     */
    @JvmName("npyljnttsvraktnd")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value Specifies the security identifier (SID).
     */
    @JvmName("blmckqwohpwpegjd")
    public suspend fun domainSid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainSid = mapped
    }

    /**
     * @param value Specifies the Active Directory forest to get.
     */
    @JvmName("xkuovcqplkxegmjv")
    public suspend fun forestName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forestName = mapped
    }

    /**
     * @param value Specifies the NetBIOS domain name.
     */
    @JvmName("mnpbmjxfcuypfoeg")
    public suspend fun netBiosDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netBiosDomainName = mapped
    }

    /**
     * @param value Specifies the Active Directory SAMAccountName for Azure Storage.
     */
    @JvmName("btilfftbwclbvpxw")
    public suspend fun samAccountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samAccountName = mapped
    }

    internal fun build(): ActiveDirectoryPropertiesArgs = ActiveDirectoryPropertiesArgs(
        accountType = accountType,
        azureStorageSid = azureStorageSid,
        domainGuid = domainGuid ?: throw PulumiNullFieldException("domainGuid"),
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        domainSid = domainSid,
        forestName = forestName,
        netBiosDomainName = netBiosDomainName,
        samAccountName = samAccountName,
    )
}
