@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.BlobInventoryPolicyDefinitionArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.Format
import com.pulumi.azurenative.storage.kotlin.enums.ObjectType
import com.pulumi.azurenative.storage.kotlin.enums.Schedule
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An object that defines the blob inventory rule.
 * @property filters An object that defines the filter set.
 * @property format This is a required field, it specifies the format for the inventory files.
 * @property objectType This is a required field. This field specifies the scope of the inventory created either at the blob or container level.
 * @property schedule This is a required field. This field is used to schedule an inventory formation.
 * @property schemaFields This is a required field. This field specifies the fields and properties of the object to be included in the inventory. The Schema field value 'Name' is always required. The valid values for this field for the 'Blob' definition.objectType include 'Name, Creation-Time, Last-Modified, Content-Length, Content-MD5, BlobType, AccessTier, AccessTierChangeTime, AccessTierInferred, Tags, Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, Snapshot, VersionId, IsCurrentVersion, Metadata, LastAccessTime, Tags, Etag, ContentType, ContentEncoding, ContentLanguage, ContentCRC64, CacheControl, ContentDisposition, LeaseStatus, LeaseState, LeaseDuration, ServerEncrypted, Deleted, DeletionId, DeletedTime, RemainingRetentionDays, ImmutabilityPolicyUntilDate, ImmutabilityPolicyMode, LegalHold, CopyId, CopyStatus, CopySource, CopyProgress, CopyCompletionTime, CopyStatusDescription, CustomerProvidedKeySha256, RehydratePriority, ArchiveStatus, XmsBlobSequenceNumber, EncryptionScope, IncrementalCopy, TagCount'. For Blob object type schema field value 'DeletedTime' is applicable only for Hns enabled accounts. The valid values for 'Container' definition.objectType include 'Name, Last-Modified, Metadata, LeaseStatus, LeaseState, LeaseDuration, PublicAccess, HasImmutabilityPolicy, HasLegalHold, Etag, DefaultEncryptionScope, DenyEncryptionScopeOverride, ImmutableStorageWithVersioningEnabled, Deleted, Version, DeletedTime, RemainingRetentionDays'. Schema field values 'Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, DeletionId' are valid only for Hns enabled accounts.Schema field values 'Tags, TagCount' are only valid for Non-Hns accounts.
 */
public data class BlobInventoryPolicyDefinitionArgs(
    public val filters: Output<BlobInventoryPolicyFilterArgs>? = null,
    public val format: Output<Either<String, Format>>,
    public val objectType: Output<Either<String, ObjectType>>,
    public val schedule: Output<Either<String, Schedule>>,
    public val schemaFields: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.BlobInventoryPolicyDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.BlobInventoryPolicyDefinitionArgs =
        com.pulumi.azurenative.storage.inputs.BlobInventoryPolicyDefinitionArgs.builder()
            .filters(filters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .format(
                format.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .objectType(
                objectType.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .schedule(
                schedule.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .schemaFields(schemaFields.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BlobInventoryPolicyDefinitionArgs].
 */
@PulumiTagMarker
public class BlobInventoryPolicyDefinitionArgsBuilder internal constructor() {
    private var filters: Output<BlobInventoryPolicyFilterArgs>? = null

    private var format: Output<Either<String, Format>>? = null

    private var objectType: Output<Either<String, ObjectType>>? = null

    private var schedule: Output<Either<String, Schedule>>? = null

    private var schemaFields: Output<List<String>>? = null

    /**
     * @param value An object that defines the filter set.
     */
    @JvmName("epecqsdiituxfhim")
    public suspend fun filters(`value`: Output<BlobInventoryPolicyFilterArgs>) {
        this.filters = value
    }

    /**
     * @param value This is a required field, it specifies the format for the inventory files.
     */
    @JvmName("vllgfomogmwtaisw")
    public suspend fun format(`value`: Output<Either<String, Format>>) {
        this.format = value
    }

    /**
     * @param value This is a required field. This field specifies the scope of the inventory created either at the blob or container level.
     */
    @JvmName("wdfsmhmsrckfyjcx")
    public suspend fun objectType(`value`: Output<Either<String, ObjectType>>) {
        this.objectType = value
    }

    /**
     * @param value This is a required field. This field is used to schedule an inventory formation.
     */
    @JvmName("pwpdlbtdyesxqncj")
    public suspend fun schedule(`value`: Output<Either<String, Schedule>>) {
        this.schedule = value
    }

    /**
     * @param value This is a required field. This field specifies the fields and properties of the object to be included in the inventory. The Schema field value 'Name' is always required. The valid values for this field for the 'Blob' definition.objectType include 'Name, Creation-Time, Last-Modified, Content-Length, Content-MD5, BlobType, AccessTier, AccessTierChangeTime, AccessTierInferred, Tags, Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, Snapshot, VersionId, IsCurrentVersion, Metadata, LastAccessTime, Tags, Etag, ContentType, ContentEncoding, ContentLanguage, ContentCRC64, CacheControl, ContentDisposition, LeaseStatus, LeaseState, LeaseDuration, ServerEncrypted, Deleted, DeletionId, DeletedTime, RemainingRetentionDays, ImmutabilityPolicyUntilDate, ImmutabilityPolicyMode, LegalHold, CopyId, CopyStatus, CopySource, CopyProgress, CopyCompletionTime, CopyStatusDescription, CustomerProvidedKeySha256, RehydratePriority, ArchiveStatus, XmsBlobSequenceNumber, EncryptionScope, IncrementalCopy, TagCount'. For Blob object type schema field value 'DeletedTime' is applicable only for Hns enabled accounts. The valid values for 'Container' definition.objectType include 'Name, Last-Modified, Metadata, LeaseStatus, LeaseState, LeaseDuration, PublicAccess, HasImmutabilityPolicy, HasLegalHold, Etag, DefaultEncryptionScope, DenyEncryptionScopeOverride, ImmutableStorageWithVersioningEnabled, Deleted, Version, DeletedTime, RemainingRetentionDays'. Schema field values 'Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, DeletionId' are valid only for Hns enabled accounts.Schema field values 'Tags, TagCount' are only valid for Non-Hns accounts.
     */
    @JvmName("kuoweaxxfasakpjh")
    public suspend fun schemaFields(`value`: Output<List<String>>) {
        this.schemaFields = value
    }

    @JvmName("keduehymxugmcato")
    public suspend fun schemaFields(vararg values: Output<String>) {
        this.schemaFields = Output.all(values.asList())
    }

    /**
     * @param values This is a required field. This field specifies the fields and properties of the object to be included in the inventory. The Schema field value 'Name' is always required. The valid values for this field for the 'Blob' definition.objectType include 'Name, Creation-Time, Last-Modified, Content-Length, Content-MD5, BlobType, AccessTier, AccessTierChangeTime, AccessTierInferred, Tags, Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, Snapshot, VersionId, IsCurrentVersion, Metadata, LastAccessTime, Tags, Etag, ContentType, ContentEncoding, ContentLanguage, ContentCRC64, CacheControl, ContentDisposition, LeaseStatus, LeaseState, LeaseDuration, ServerEncrypted, Deleted, DeletionId, DeletedTime, RemainingRetentionDays, ImmutabilityPolicyUntilDate, ImmutabilityPolicyMode, LegalHold, CopyId, CopyStatus, CopySource, CopyProgress, CopyCompletionTime, CopyStatusDescription, CustomerProvidedKeySha256, RehydratePriority, ArchiveStatus, XmsBlobSequenceNumber, EncryptionScope, IncrementalCopy, TagCount'. For Blob object type schema field value 'DeletedTime' is applicable only for Hns enabled accounts. The valid values for 'Container' definition.objectType include 'Name, Last-Modified, Metadata, LeaseStatus, LeaseState, LeaseDuration, PublicAccess, HasImmutabilityPolicy, HasLegalHold, Etag, DefaultEncryptionScope, DenyEncryptionScopeOverride, ImmutableStorageWithVersioningEnabled, Deleted, Version, DeletedTime, RemainingRetentionDays'. Schema field values 'Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, DeletionId' are valid only for Hns enabled accounts.Schema field values 'Tags, TagCount' are only valid for Non-Hns accounts.
     */
    @JvmName("benxgkfetmvxrscg")
    public suspend fun schemaFields(values: List<Output<String>>) {
        this.schemaFields = Output.all(values)
    }

    /**
     * @param value An object that defines the filter set.
     */
    @JvmName("flsqvnlnrrkwcauq")
    public suspend fun filters(`value`: BlobInventoryPolicyFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument An object that defines the filter set.
     */
    @JvmName("qpwirohdotidkosy")
    public suspend fun filters(argument: suspend BlobInventoryPolicyFilterArgsBuilder.() -> Unit) {
        val toBeMapped = BlobInventoryPolicyFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param value This is a required field, it specifies the format for the inventory files.
     */
    @JvmName("sbgqfcafopemciqm")
    public suspend fun format(`value`: Either<String, Format>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value This is a required field, it specifies the format for the inventory files.
     */
    @JvmName("wdwhrkjphtteibri")
    public fun format(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Format>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value This is a required field, it specifies the format for the inventory files.
     */
    @JvmName("vulroqixniymlkpa")
    public fun format(`value`: Format) {
        val toBeMapped = Either.ofRight<String, Format>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.format = mapped
    }

    /**
     * @param value This is a required field. This field specifies the scope of the inventory created either at the blob or container level.
     */
    @JvmName("sqbqgkwesujjatrl")
    public suspend fun objectType(`value`: Either<String, ObjectType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value This is a required field. This field specifies the scope of the inventory created either at the blob or container level.
     */
    @JvmName("inlwkqsjcoixwlva")
    public fun objectType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ObjectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value This is a required field. This field specifies the scope of the inventory created either at the blob or container level.
     */
    @JvmName("kilgmvprhuywkptt")
    public fun objectType(`value`: ObjectType) {
        val toBeMapped = Either.ofRight<String, ObjectType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.objectType = mapped
    }

    /**
     * @param value This is a required field. This field is used to schedule an inventory formation.
     */
    @JvmName("qwdmfeabtaqdeukn")
    public suspend fun schedule(`value`: Either<String, Schedule>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value This is a required field. This field is used to schedule an inventory formation.
     */
    @JvmName("etnhqpcaabbyhfyi")
    public fun schedule(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Schedule>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value This is a required field. This field is used to schedule an inventory formation.
     */
    @JvmName("aibynluiwavtthpi")
    public fun schedule(`value`: Schedule) {
        val toBeMapped = Either.ofRight<String, Schedule>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param value This is a required field. This field specifies the fields and properties of the object to be included in the inventory. The Schema field value 'Name' is always required. The valid values for this field for the 'Blob' definition.objectType include 'Name, Creation-Time, Last-Modified, Content-Length, Content-MD5, BlobType, AccessTier, AccessTierChangeTime, AccessTierInferred, Tags, Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, Snapshot, VersionId, IsCurrentVersion, Metadata, LastAccessTime, Tags, Etag, ContentType, ContentEncoding, ContentLanguage, ContentCRC64, CacheControl, ContentDisposition, LeaseStatus, LeaseState, LeaseDuration, ServerEncrypted, Deleted, DeletionId, DeletedTime, RemainingRetentionDays, ImmutabilityPolicyUntilDate, ImmutabilityPolicyMode, LegalHold, CopyId, CopyStatus, CopySource, CopyProgress, CopyCompletionTime, CopyStatusDescription, CustomerProvidedKeySha256, RehydratePriority, ArchiveStatus, XmsBlobSequenceNumber, EncryptionScope, IncrementalCopy, TagCount'. For Blob object type schema field value 'DeletedTime' is applicable only for Hns enabled accounts. The valid values for 'Container' definition.objectType include 'Name, Last-Modified, Metadata, LeaseStatus, LeaseState, LeaseDuration, PublicAccess, HasImmutabilityPolicy, HasLegalHold, Etag, DefaultEncryptionScope, DenyEncryptionScopeOverride, ImmutableStorageWithVersioningEnabled, Deleted, Version, DeletedTime, RemainingRetentionDays'. Schema field values 'Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, DeletionId' are valid only for Hns enabled accounts.Schema field values 'Tags, TagCount' are only valid for Non-Hns accounts.
     */
    @JvmName("cgunroocdpoekvmm")
    public suspend fun schemaFields(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaFields = mapped
    }

    /**
     * @param values This is a required field. This field specifies the fields and properties of the object to be included in the inventory. The Schema field value 'Name' is always required. The valid values for this field for the 'Blob' definition.objectType include 'Name, Creation-Time, Last-Modified, Content-Length, Content-MD5, BlobType, AccessTier, AccessTierChangeTime, AccessTierInferred, Tags, Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, Snapshot, VersionId, IsCurrentVersion, Metadata, LastAccessTime, Tags, Etag, ContentType, ContentEncoding, ContentLanguage, ContentCRC64, CacheControl, ContentDisposition, LeaseStatus, LeaseState, LeaseDuration, ServerEncrypted, Deleted, DeletionId, DeletedTime, RemainingRetentionDays, ImmutabilityPolicyUntilDate, ImmutabilityPolicyMode, LegalHold, CopyId, CopyStatus, CopySource, CopyProgress, CopyCompletionTime, CopyStatusDescription, CustomerProvidedKeySha256, RehydratePriority, ArchiveStatus, XmsBlobSequenceNumber, EncryptionScope, IncrementalCopy, TagCount'. For Blob object type schema field value 'DeletedTime' is applicable only for Hns enabled accounts. The valid values for 'Container' definition.objectType include 'Name, Last-Modified, Metadata, LeaseStatus, LeaseState, LeaseDuration, PublicAccess, HasImmutabilityPolicy, HasLegalHold, Etag, DefaultEncryptionScope, DenyEncryptionScopeOverride, ImmutableStorageWithVersioningEnabled, Deleted, Version, DeletedTime, RemainingRetentionDays'. Schema field values 'Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, DeletionId' are valid only for Hns enabled accounts.Schema field values 'Tags, TagCount' are only valid for Non-Hns accounts.
     */
    @JvmName("hcecrrbrusxvleka")
    public suspend fun schemaFields(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schemaFields = mapped
    }

    internal fun build(): BlobInventoryPolicyDefinitionArgs = BlobInventoryPolicyDefinitionArgs(
        filters = filters,
        format = format ?: throw PulumiNullFieldException("format"),
        objectType = objectType ?: throw PulumiNullFieldException("objectType"),
        schedule = schedule ?: throw PulumiNullFieldException("schedule"),
        schemaFields = schemaFields ?: throw PulumiNullFieldException("schemaFields"),
    )
}
