@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.BlobInventoryPolicyFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An object that defines the blob inventory rule filter conditions. For 'Blob' definition.objectType all filter properties are applicable, 'blobTypes' is required and others are optional. For 'Container' definition.objectType only prefixMatch is applicable and is optional.
 * @property blobTypes An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not support pageBlobs. This field is required when definition.objectType property is set to 'Blob'.
 * @property excludePrefix An array of strings with maximum 10 blob prefixes to be excluded from the inventory.
 * @property includeBlobVersions Includes blob versions in blob inventory when value is set to true. The definition.schemaFields values 'VersionId and IsCurrentVersion' are required if this property is set to true, else they must be excluded.
 * @property includeDeleted For 'Container' definition.objectType the definition.schemaFields must include 'Deleted, Version, DeletedTime and RemainingRetentionDays'. For 'Blob' definition.objectType and HNS enabled storage accounts the definition.schemaFields must include 'DeletionId, Deleted, DeletedTime and RemainingRetentionDays' and for Hns disabled accounts the definition.schemaFields must include 'Deleted and RemainingRetentionDays', else it must be excluded.
 * @property includeSnapshots Includes blob snapshots in blob inventory when value is set to true. The definition.schemaFields value 'Snapshot' is required if this property is set to true, else it must be excluded.
 * @property prefixMatch An array of strings with maximum 10 blob prefixes to be included in the inventory.
 */
public data class BlobInventoryPolicyFilterArgs(
    public val blobTypes: Output<List<String>>? = null,
    public val excludePrefix: Output<List<String>>? = null,
    public val includeBlobVersions: Output<Boolean>? = null,
    public val includeDeleted: Output<Boolean>? = null,
    public val includeSnapshots: Output<Boolean>? = null,
    public val prefixMatch: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.BlobInventoryPolicyFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.BlobInventoryPolicyFilterArgs =
        com.pulumi.azurenative.storage.inputs.BlobInventoryPolicyFilterArgs.builder()
            .blobTypes(blobTypes?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .excludePrefix(excludePrefix?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeBlobVersions(includeBlobVersions?.applyValue({ args0 -> args0 }))
            .includeDeleted(includeDeleted?.applyValue({ args0 -> args0 }))
            .includeSnapshots(includeSnapshots?.applyValue({ args0 -> args0 }))
            .prefixMatch(prefixMatch?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [BlobInventoryPolicyFilterArgs].
 */
@PulumiTagMarker
public class BlobInventoryPolicyFilterArgsBuilder internal constructor() {
    private var blobTypes: Output<List<String>>? = null

    private var excludePrefix: Output<List<String>>? = null

    private var includeBlobVersions: Output<Boolean>? = null

    private var includeDeleted: Output<Boolean>? = null

    private var includeSnapshots: Output<Boolean>? = null

    private var prefixMatch: Output<List<String>>? = null

    /**
     * @param value An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not support pageBlobs. This field is required when definition.objectType property is set to 'Blob'.
     */
    @JvmName("uoxaxkpnrjhihvwh")
    public suspend fun blobTypes(`value`: Output<List<String>>) {
        this.blobTypes = value
    }

    @JvmName("gddvbhstqioqumft")
    public suspend fun blobTypes(vararg values: Output<String>) {
        this.blobTypes = Output.all(values.asList())
    }

    /**
     * @param values An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not support pageBlobs. This field is required when definition.objectType property is set to 'Blob'.
     */
    @JvmName("rwphfhdoehxgtfim")
    public suspend fun blobTypes(values: List<Output<String>>) {
        this.blobTypes = Output.all(values)
    }

    /**
     * @param value An array of strings with maximum 10 blob prefixes to be excluded from the inventory.
     */
    @JvmName("mjwubaowfsswnahs")
    public suspend fun excludePrefix(`value`: Output<List<String>>) {
        this.excludePrefix = value
    }

    @JvmName("ppddfwiuklqmoijo")
    public suspend fun excludePrefix(vararg values: Output<String>) {
        this.excludePrefix = Output.all(values.asList())
    }

    /**
     * @param values An array of strings with maximum 10 blob prefixes to be excluded from the inventory.
     */
    @JvmName("ylwxidunvefjxuck")
    public suspend fun excludePrefix(values: List<Output<String>>) {
        this.excludePrefix = Output.all(values)
    }

    /**
     * @param value Includes blob versions in blob inventory when value is set to true. The definition.schemaFields values 'VersionId and IsCurrentVersion' are required if this property is set to true, else they must be excluded.
     */
    @JvmName("ysqrdpspyxiatepo")
    public suspend fun includeBlobVersions(`value`: Output<Boolean>) {
        this.includeBlobVersions = value
    }

    /**
     * @param value For 'Container' definition.objectType the definition.schemaFields must include 'Deleted, Version, DeletedTime and RemainingRetentionDays'. For 'Blob' definition.objectType and HNS enabled storage accounts the definition.schemaFields must include 'DeletionId, Deleted, DeletedTime and RemainingRetentionDays' and for Hns disabled accounts the definition.schemaFields must include 'Deleted and RemainingRetentionDays', else it must be excluded.
     */
    @JvmName("geakosgsnmqwqaow")
    public suspend fun includeDeleted(`value`: Output<Boolean>) {
        this.includeDeleted = value
    }

    /**
     * @param value Includes blob snapshots in blob inventory when value is set to true. The definition.schemaFields value 'Snapshot' is required if this property is set to true, else it must be excluded.
     */
    @JvmName("amwkbrcpkibdcomo")
    public suspend fun includeSnapshots(`value`: Output<Boolean>) {
        this.includeSnapshots = value
    }

    /**
     * @param value An array of strings with maximum 10 blob prefixes to be included in the inventory.
     */
    @JvmName("nmrhdadovrqbjjhp")
    public suspend fun prefixMatch(`value`: Output<List<String>>) {
        this.prefixMatch = value
    }

    @JvmName("hckvqhtytbvnqgpc")
    public suspend fun prefixMatch(vararg values: Output<String>) {
        this.prefixMatch = Output.all(values.asList())
    }

    /**
     * @param values An array of strings with maximum 10 blob prefixes to be included in the inventory.
     */
    @JvmName("iikywrofrwlgveud")
    public suspend fun prefixMatch(values: List<Output<String>>) {
        this.prefixMatch = Output.all(values)
    }

    /**
     * @param value An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not support pageBlobs. This field is required when definition.objectType property is set to 'Blob'.
     */
    @JvmName("nbtjynsdxxhfgavk")
    public suspend fun blobTypes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobTypes = mapped
    }

    /**
     * @param values An array of predefined enum values. Valid values include blockBlob, appendBlob, pageBlob. Hns accounts does not support pageBlobs. This field is required when definition.objectType property is set to 'Blob'.
     */
    @JvmName("dfybbcpoqsticpis")
    public suspend fun blobTypes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.blobTypes = mapped
    }

    /**
     * @param value An array of strings with maximum 10 blob prefixes to be excluded from the inventory.
     */
    @JvmName("acmdyvnvgridpmsk")
    public suspend fun excludePrefix(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludePrefix = mapped
    }

    /**
     * @param values An array of strings with maximum 10 blob prefixes to be excluded from the inventory.
     */
    @JvmName("xtkwgqtcaixxqeof")
    public suspend fun excludePrefix(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.excludePrefix = mapped
    }

    /**
     * @param value Includes blob versions in blob inventory when value is set to true. The definition.schemaFields values 'VersionId and IsCurrentVersion' are required if this property is set to true, else they must be excluded.
     */
    @JvmName("yaknxmxobaugvulk")
    public suspend fun includeBlobVersions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeBlobVersions = mapped
    }

    /**
     * @param value For 'Container' definition.objectType the definition.schemaFields must include 'Deleted, Version, DeletedTime and RemainingRetentionDays'. For 'Blob' definition.objectType and HNS enabled storage accounts the definition.schemaFields must include 'DeletionId, Deleted, DeletedTime and RemainingRetentionDays' and for Hns disabled accounts the definition.schemaFields must include 'Deleted and RemainingRetentionDays', else it must be excluded.
     */
    @JvmName("ypilbbntlxpbwsmo")
    public suspend fun includeDeleted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeDeleted = mapped
    }

    /**
     * @param value Includes blob snapshots in blob inventory when value is set to true. The definition.schemaFields value 'Snapshot' is required if this property is set to true, else it must be excluded.
     */
    @JvmName("imgmycsexappitwo")
    public suspend fun includeSnapshots(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeSnapshots = mapped
    }

    /**
     * @param value An array of strings with maximum 10 blob prefixes to be included in the inventory.
     */
    @JvmName("mquqttapceifcdkv")
    public suspend fun prefixMatch(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.prefixMatch = mapped
    }

    /**
     * @param values An array of strings with maximum 10 blob prefixes to be included in the inventory.
     */
    @JvmName("kiwpiffgmrnehoqd")
    public suspend fun prefixMatch(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.prefixMatch = mapped
    }

    internal fun build(): BlobInventoryPolicyFilterArgs = BlobInventoryPolicyFilterArgs(
        blobTypes = blobTypes,
        excludePrefix = excludePrefix,
        includeBlobVersions = includeBlobVersions,
        includeDeleted = includeDeleted,
        includeSnapshots = includeSnapshots,
        prefixMatch = prefixMatch,
    )
}
