@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ChangeFeedArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The blob service properties for change feed events.
 * @property enabled Indicates whether change feed event logging is enabled for the Blob service.
 * @property retentionInDays Indicates the duration of changeFeed retention in days. Minimum value is 1 day and maximum value is 146000 days (400 years). A null value indicates an infinite retention of the change feed.
 */
public data class ChangeFeedArgs(
    public val enabled: Output<Boolean>? = null,
    public val retentionInDays: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ChangeFeedArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ChangeFeedArgs =
        com.pulumi.azurenative.storage.inputs.ChangeFeedArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .retentionInDays(retentionInDays?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChangeFeedArgs].
 */
@PulumiTagMarker
public class ChangeFeedArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var retentionInDays: Output<Int>? = null

    /**
     * @param value Indicates whether change feed event logging is enabled for the Blob service.
     */
    @JvmName("edsiabqwuxxkpyra")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Indicates the duration of changeFeed retention in days. Minimum value is 1 day and maximum value is 146000 days (400 years). A null value indicates an infinite retention of the change feed.
     */
    @JvmName("oghtldhwynjjkjgr")
    public suspend fun retentionInDays(`value`: Output<Int>) {
        this.retentionInDays = value
    }

    /**
     * @param value Indicates whether change feed event logging is enabled for the Blob service.
     */
    @JvmName("qavjitxhwvtdkyoq")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Indicates the duration of changeFeed retention in days. Minimum value is 1 day and maximum value is 146000 days (400 years). A null value indicates an infinite retention of the change feed.
     */
    @JvmName("bqrxpvnwntdloore")
    public suspend fun retentionInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionInDays = mapped
    }

    internal fun build(): ChangeFeedArgs = ChangeFeedArgs(
        enabled = enabled,
        retentionInDays = retentionInDays,
    )
}
