@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.CorsRuleArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.AllowedMethods
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies a CORS rule for the Blob service.
 * @property allowedHeaders Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
 * @property allowedMethods Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
 * @property allowedOrigins Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
 * @property exposedHeaders Required if CorsRule element is present. A list of response headers to expose to CORS clients.
 * @property maxAgeInSeconds Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight response.
 */
public data class CorsRuleArgs(
    public val allowedHeaders: Output<List<String>>,
    public val allowedMethods: Output<List<Either<String, AllowedMethods>>>,
    public val allowedOrigins: Output<List<String>>,
    public val exposedHeaders: Output<List<String>>,
    public val maxAgeInSeconds: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.CorsRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.CorsRuleArgs =
        com.pulumi.azurenative.storage.inputs.CorsRuleArgs.builder()
            .allowedHeaders(allowedHeaders.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .allowedMethods(
                allowedMethods.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .allowedOrigins(allowedOrigins.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .exposedHeaders(exposedHeaders.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxAgeInSeconds(maxAgeInSeconds.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CorsRuleArgs].
 */
@PulumiTagMarker
public class CorsRuleArgsBuilder internal constructor() {
    private var allowedHeaders: Output<List<String>>? = null

    private var allowedMethods: Output<List<Either<String, AllowedMethods>>>? = null

    private var allowedOrigins: Output<List<String>>? = null

    private var exposedHeaders: Output<List<String>>? = null

    private var maxAgeInSeconds: Output<Int>? = null

    /**
     * @param value Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
     */
    @JvmName("irewegojjblyvpjf")
    public suspend fun allowedHeaders(`value`: Output<List<String>>) {
        this.allowedHeaders = value
    }

    @JvmName("lxtlpwkyorvygkyw")
    public suspend fun allowedHeaders(vararg values: Output<String>) {
        this.allowedHeaders = Output.all(values.asList())
    }

    /**
     * @param values Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
     */
    @JvmName("wdkoxtfttyfrsyud")
    public suspend fun allowedHeaders(values: List<Output<String>>) {
        this.allowedHeaders = Output.all(values)
    }

    /**
     * @param value Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
     */
    @JvmName("ldefumxyfyqtdubr")
    public suspend fun allowedMethods(`value`: Output<List<Either<String, AllowedMethods>>>) {
        this.allowedMethods = value
    }

    @JvmName("vdatvfhlmhkiwdsw")
    public suspend fun allowedMethods(vararg values: Output<Either<String, AllowedMethods>>) {
        this.allowedMethods = Output.all(values.asList())
    }

    /**
     * @param values Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
     */
    @JvmName("akixpnunrwrgqtep")
    public suspend fun allowedMethods(values: List<Output<Either<String, AllowedMethods>>>) {
        this.allowedMethods = Output.all(values)
    }

    /**
     * @param value Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
     */
    @JvmName("flyoynrrvovvdhip")
    public suspend fun allowedOrigins(`value`: Output<List<String>>) {
        this.allowedOrigins = value
    }

    @JvmName("ewrxinddwafvfjyp")
    public suspend fun allowedOrigins(vararg values: Output<String>) {
        this.allowedOrigins = Output.all(values.asList())
    }

    /**
     * @param values Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
     */
    @JvmName("qjhiriilsmlsrrcf")
    public suspend fun allowedOrigins(values: List<Output<String>>) {
        this.allowedOrigins = Output.all(values)
    }

    /**
     * @param value Required if CorsRule element is present. A list of response headers to expose to CORS clients.
     */
    @JvmName("myrbksnepfbpvhcd")
    public suspend fun exposedHeaders(`value`: Output<List<String>>) {
        this.exposedHeaders = value
    }

    @JvmName("opnvihkfaxomtvxk")
    public suspend fun exposedHeaders(vararg values: Output<String>) {
        this.exposedHeaders = Output.all(values.asList())
    }

    /**
     * @param values Required if CorsRule element is present. A list of response headers to expose to CORS clients.
     */
    @JvmName("npitybatjqskyuab")
    public suspend fun exposedHeaders(values: List<Output<String>>) {
        this.exposedHeaders = Output.all(values)
    }

    /**
     * @param value Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight response.
     */
    @JvmName("aumiewtopvxkluod")
    public suspend fun maxAgeInSeconds(`value`: Output<Int>) {
        this.maxAgeInSeconds = value
    }

    /**
     * @param value Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
     */
    @JvmName("mbdkiojqixkbtvxk")
    public suspend fun allowedHeaders(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param values Required if CorsRule element is present. A list of headers allowed to be part of the cross-origin request.
     */
    @JvmName("ddxqiixatigqbyer")
    public suspend fun allowedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedHeaders = mapped
    }

    /**
     * @param value Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
     */
    @JvmName("vhjbikvjxjghcrxc")
    public suspend fun allowedMethods(`value`: List<Either<String, AllowedMethods>>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param values Required if CorsRule element is present. A list of HTTP methods that are allowed to be executed by the origin.
     */
    @JvmName("edbgvvcoskxclepq")
    public suspend fun allowedMethods(vararg values: Either<String, AllowedMethods>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedMethods = mapped
    }

    /**
     * @param value Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
     */
    @JvmName("fjsbaxpdmhklcodl")
    public suspend fun allowedOrigins(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param values Required if CorsRule element is present. A list of origin domains that will be allowed via CORS, or "*" to allow all domains
     */
    @JvmName("aufljdxbkpvkolnb")
    public suspend fun allowedOrigins(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.allowedOrigins = mapped
    }

    /**
     * @param value Required if CorsRule element is present. A list of response headers to expose to CORS clients.
     */
    @JvmName("mmhjtbwpxehbehtg")
    public suspend fun exposedHeaders(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exposedHeaders = mapped
    }

    /**
     * @param values Required if CorsRule element is present. A list of response headers to expose to CORS clients.
     */
    @JvmName("valhgqwnegshsxos")
    public suspend fun exposedHeaders(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exposedHeaders = mapped
    }

    /**
     * @param value Required if CorsRule element is present. The number of seconds that the client/browser should cache a preflight response.
     */
    @JvmName("mkyxtmgrcyppcouu")
    public suspend fun maxAgeInSeconds(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxAgeInSeconds = mapped
    }

    internal fun build(): CorsRuleArgs = CorsRuleArgs(
        allowedHeaders = allowedHeaders ?: throw PulumiNullFieldException("allowedHeaders"),
        allowedMethods = allowedMethods ?: throw PulumiNullFieldException("allowedMethods"),
        allowedOrigins = allowedOrigins ?: throw PulumiNullFieldException("allowedOrigins"),
        exposedHeaders = exposedHeaders ?: throw PulumiNullFieldException("exposedHeaders"),
        maxAgeInSeconds = maxAgeInSeconds ?: throw PulumiNullFieldException("maxAgeInSeconds"),
    )
}
