@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.EncryptionArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.KeySource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The encryption settings on the storage account.
 * @property encryptionIdentity The identity to be used with service-side encryption at rest.
 * @property keySource The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
 * @property keyVaultProperties Properties provided by key vault.
 * @property requireInfrastructureEncryption A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
 * @property services List of services which support encryption.
 */
public data class EncryptionArgs(
    public val encryptionIdentity: Output<EncryptionIdentityArgs>? = null,
    public val keySource: Output<Either<String, KeySource>>? = null,
    public val keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null,
    public val requireInfrastructureEncryption: Output<Boolean>? = null,
    public val services: Output<EncryptionServicesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.EncryptionArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.EncryptionArgs =
        com.pulumi.azurenative.storage.inputs.EncryptionArgs.builder()
            .encryptionIdentity(
                encryptionIdentity?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .keySource(
                keySource?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .requireInfrastructureEncryption(requireInfrastructureEncryption?.applyValue({ args0 -> args0 }))
            .services(services?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EncryptionArgs].
 */
@PulumiTagMarker
public class EncryptionArgsBuilder internal constructor() {
    private var encryptionIdentity: Output<EncryptionIdentityArgs>? = null

    private var keySource: Output<Either<String, KeySource>>? = null

    private var keyVaultProperties: Output<KeyVaultPropertiesArgs>? = null

    private var requireInfrastructureEncryption: Output<Boolean>? = null

    private var services: Output<EncryptionServicesArgs>? = null

    /**
     * @param value The identity to be used with service-side encryption at rest.
     */
    @JvmName("ukwyimaosdbsxiou")
    public suspend fun encryptionIdentity(`value`: Output<EncryptionIdentityArgs>) {
        this.encryptionIdentity = value
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
     */
    @JvmName("xnrhbgqoevaqmmet")
    public suspend fun keySource(`value`: Output<Either<String, KeySource>>) {
        this.keySource = value
    }

    /**
     * @param value Properties provided by key vault.
     */
    @JvmName("xfuxnipwqkjcgxws")
    public suspend fun keyVaultProperties(`value`: Output<KeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
     */
    @JvmName("ewbisfwmyaaqktii")
    public suspend fun requireInfrastructureEncryption(`value`: Output<Boolean>) {
        this.requireInfrastructureEncryption = value
    }

    /**
     * @param value List of services which support encryption.
     */
    @JvmName("degantgcaywfshfb")
    public suspend fun services(`value`: Output<EncryptionServicesArgs>) {
        this.services = value
    }

    /**
     * @param value The identity to be used with service-side encryption at rest.
     */
    @JvmName("evamiiwsyriywtwe")
    public suspend fun encryptionIdentity(`value`: EncryptionIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionIdentity = mapped
    }

    /**
     * @param argument The identity to be used with service-side encryption at rest.
     */
    @JvmName("jkscebppncbhkwyf")
    public suspend
    fun encryptionIdentity(argument: suspend EncryptionIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionIdentity = mapped
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
     */
    @JvmName("frxjrflrxhbtdodl")
    public suspend fun keySource(`value`: Either<String, KeySource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
     */
    @JvmName("etmjwwtgpetpjieg")
    public fun keySource(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value The encryption keySource (provider). Possible values (case-insensitive):  Microsoft.Storage, Microsoft.Keyvault
     */
    @JvmName("yjhhqvepyrkwmohg")
    public fun keySource(`value`: KeySource) {
        val toBeMapped = Either.ofRight<String, KeySource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keySource = mapped
    }

    /**
     * @param value Properties provided by key vault.
     */
    @JvmName("ttsctxanbsqveggn")
    public suspend fun keyVaultProperties(`value`: KeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument Properties provided by key vault.
     */
    @JvmName("vbaruhgeylktmdjt")
    public suspend
    fun keyVaultProperties(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    /**
     * @param value A boolean indicating whether or not the service applies a secondary layer of encryption with platform managed keys for data at rest.
     */
    @JvmName("svlcfuiorrmpbeqa")
    public suspend fun requireInfrastructureEncryption(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requireInfrastructureEncryption = mapped
    }

    /**
     * @param value List of services which support encryption.
     */
    @JvmName("nphrpmrghgboolxk")
    public suspend fun services(`value`: EncryptionServicesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.services = mapped
    }

    /**
     * @param argument List of services which support encryption.
     */
    @JvmName("jaehmblhqrbmbrla")
    public suspend fun services(argument: suspend EncryptionServicesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionServicesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.services = mapped
    }

    internal fun build(): EncryptionArgs = EncryptionArgs(
        encryptionIdentity = encryptionIdentity,
        keySource = keySource,
        keyVaultProperties = keyVaultProperties,
        requireInfrastructureEncryption = requireInfrastructureEncryption,
        services = services,
    )
}
