@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.EncryptionIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Encryption identity for the storage account.
 * @property encryptionFederatedIdentityClientId ClientId of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the storage account.
 * @property encryptionUserAssignedIdentity Resource identifier of the UserAssigned identity to be associated with server-side encryption on the storage account.
 */
public data class EncryptionIdentityArgs(
    public val encryptionFederatedIdentityClientId: Output<String>? = null,
    public val encryptionUserAssignedIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.EncryptionIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.EncryptionIdentityArgs =
        com.pulumi.azurenative.storage.inputs.EncryptionIdentityArgs.builder()
            .encryptionFederatedIdentityClientId(
                encryptionFederatedIdentityClientId?.applyValue({ args0 ->
                    args0
                }),
            )
            .encryptionUserAssignedIdentity(
                encryptionUserAssignedIdentity?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [EncryptionIdentityArgs].
 */
@PulumiTagMarker
public class EncryptionIdentityArgsBuilder internal constructor() {
    private var encryptionFederatedIdentityClientId: Output<String>? = null

    private var encryptionUserAssignedIdentity: Output<String>? = null

    /**
     * @param value ClientId of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the storage account.
     */
    @JvmName("uaemnjgcamkhapcg")
    public suspend fun encryptionFederatedIdentityClientId(`value`: Output<String>) {
        this.encryptionFederatedIdentityClientId = value
    }

    /**
     * @param value Resource identifier of the UserAssigned identity to be associated with server-side encryption on the storage account.
     */
    @JvmName("fpxhbfsxtftdskmc")
    public suspend fun encryptionUserAssignedIdentity(`value`: Output<String>) {
        this.encryptionUserAssignedIdentity = value
    }

    /**
     * @param value ClientId of the multi-tenant application to be used in conjunction with the user-assigned identity for cross-tenant customer-managed-keys server-side encryption on the storage account.
     */
    @JvmName("iencljxqctfljqrp")
    public suspend fun encryptionFederatedIdentityClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionFederatedIdentityClientId = mapped
    }

    /**
     * @param value Resource identifier of the UserAssigned identity to be associated with server-side encryption on the storage account.
     */
    @JvmName("llbisosqgmcluudf")
    public suspend fun encryptionUserAssignedIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionUserAssignedIdentity = mapped
    }

    internal fun build(): EncryptionIdentityArgs = EncryptionIdentityArgs(
        encryptionFederatedIdentityClientId = encryptionFederatedIdentityClientId,
        encryptionUserAssignedIdentity = encryptionUserAssignedIdentity,
    )
}
