@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.EncryptionScopeKeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The key vault properties for the encryption scope. This is a required field if encryption scope 'source' attribute is set to 'Microsoft.KeyVault'.
 * @property keyUri The object identifier for a key vault key object. When applied, the encryption scope will use the key referenced by the identifier to enable customer-managed key support on this encryption scope.
 */
public data class EncryptionScopeKeyVaultPropertiesArgs(
    public val keyUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.EncryptionScopeKeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.EncryptionScopeKeyVaultPropertiesArgs =
        com.pulumi.azurenative.storage.inputs.EncryptionScopeKeyVaultPropertiesArgs.builder()
            .keyUri(keyUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EncryptionScopeKeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class EncryptionScopeKeyVaultPropertiesArgsBuilder internal constructor() {
    private var keyUri: Output<String>? = null

    /**
     * @param value The object identifier for a key vault key object. When applied, the encryption scope will use the key referenced by the identifier to enable customer-managed key support on this encryption scope.
     */
    @JvmName("uvtrswnxhvkqfgry")
    public suspend fun keyUri(`value`: Output<String>) {
        this.keyUri = value
    }

    /**
     * @param value The object identifier for a key vault key object. When applied, the encryption scope will use the key referenced by the identifier to enable customer-managed key support on this encryption scope.
     */
    @JvmName("nvenqfvsjxnwefuh")
    public suspend fun keyUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyUri = mapped
    }

    internal fun build(): EncryptionScopeKeyVaultPropertiesArgs =
        EncryptionScopeKeyVaultPropertiesArgs(
            keyUri = keyUri,
        )
}
