@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.KeyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A service that allows server-side encryption to be used.
 * @property enabled A boolean indicating whether or not the service encrypts the data as it is stored. Encryption at rest is enabled by default today and cannot be disabled.
 * @property keyType Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption key will be used. 'Service' key type implies that a default service key is used.
 */
public data class EncryptionServiceArgs(
    public val enabled: Output<Boolean>? = null,
    public val keyType: Output<Either<String, KeyType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs =
        com.pulumi.azurenative.storage.inputs.EncryptionServiceArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .keyType(
                keyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [EncryptionServiceArgs].
 */
@PulumiTagMarker
public class EncryptionServiceArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var keyType: Output<Either<String, KeyType>>? = null

    /**
     * @param value A boolean indicating whether or not the service encrypts the data as it is stored. Encryption at rest is enabled by default today and cannot be disabled.
     */
    @JvmName("tpthygpdugksjjel")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption key will be used. 'Service' key type implies that a default service key is used.
     */
    @JvmName("heeciwvjwysvvbkd")
    public suspend fun keyType(`value`: Output<Either<String, KeyType>>) {
        this.keyType = value
    }

    /**
     * @param value A boolean indicating whether or not the service encrypts the data as it is stored. Encryption at rest is enabled by default today and cannot be disabled.
     */
    @JvmName("lmpqfejhtjbnhsmy")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption key will be used. 'Service' key type implies that a default service key is used.
     */
    @JvmName("hhncdnowfirhfflw")
    public suspend fun keyType(`value`: Either<String, KeyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyType = mapped
    }

    /**
     * @param value Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption key will be used. 'Service' key type implies that a default service key is used.
     */
    @JvmName("andrpaelolketegk")
    public fun keyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, KeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyType = mapped
    }

    /**
     * @param value Encryption key type to be used for the encryption service. 'Account' key type implies that an account-scoped encryption key will be used. 'Service' key type implies that a default service key is used.
     */
    @JvmName("kbxgjjkwsvoybabe")
    public fun keyType(`value`: KeyType) {
        val toBeMapped = Either.ofRight<String, KeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyType = mapped
    }

    internal fun build(): EncryptionServiceArgs = EncryptionServiceArgs(
        enabled = enabled,
        keyType = keyType,
    )
}
