@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A list of services that support encryption.
 * @property blob The encryption function of the blob storage service.
 * @property file The encryption function of the file storage service.
 * @property queue The encryption function of the queue storage service.
 * @property table The encryption function of the table storage service.
 */
public data class EncryptionServicesArgs(
    public val blob: Output<EncryptionServiceArgs>? = null,
    public val `file`: Output<EncryptionServiceArgs>? = null,
    public val queue: Output<EncryptionServiceArgs>? = null,
    public val table: Output<EncryptionServiceArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs =
        com.pulumi.azurenative.storage.inputs.EncryptionServicesArgs.builder()
            .blob(blob?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .`file`(`file`?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .queue(queue?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .table(table?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [EncryptionServicesArgs].
 */
@PulumiTagMarker
public class EncryptionServicesArgsBuilder internal constructor() {
    private var blob: Output<EncryptionServiceArgs>? = null

    private var `file`: Output<EncryptionServiceArgs>? = null

    private var queue: Output<EncryptionServiceArgs>? = null

    private var table: Output<EncryptionServiceArgs>? = null

    /**
     * @param value The encryption function of the blob storage service.
     */
    @JvmName("nvdrhyusdjwiesyj")
    public suspend fun blob(`value`: Output<EncryptionServiceArgs>) {
        this.blob = value
    }

    /**
     * @param value The encryption function of the file storage service.
     */
    @JvmName("glqlmntnsfjombfs")
    public suspend fun `file`(`value`: Output<EncryptionServiceArgs>) {
        this.`file` = value
    }

    /**
     * @param value The encryption function of the queue storage service.
     */
    @JvmName("tafjhnkubacqddtc")
    public suspend fun queue(`value`: Output<EncryptionServiceArgs>) {
        this.queue = value
    }

    /**
     * @param value The encryption function of the table storage service.
     */
    @JvmName("hegghjcypietjixn")
    public suspend fun table(`value`: Output<EncryptionServiceArgs>) {
        this.table = value
    }

    /**
     * @param value The encryption function of the blob storage service.
     */
    @JvmName("xqyropscvqadeeit")
    public suspend fun blob(`value`: EncryptionServiceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blob = mapped
    }

    /**
     * @param argument The encryption function of the blob storage service.
     */
    @JvmName("hkqhctwsxjtojxld")
    public suspend fun blob(argument: suspend EncryptionServiceArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionServiceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.blob = mapped
    }

    /**
     * @param value The encryption function of the file storage service.
     */
    @JvmName("yrjrbldypsxnavah")
    public suspend fun `file`(`value`: EncryptionServiceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`file` = mapped
    }

    /**
     * @param argument The encryption function of the file storage service.
     */
    @JvmName("sxncbmaewcseebki")
    public suspend fun `file`(argument: suspend EncryptionServiceArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionServiceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.`file` = mapped
    }

    /**
     * @param value The encryption function of the queue storage service.
     */
    @JvmName("wccfpcvfhxtraqpk")
    public suspend fun queue(`value`: EncryptionServiceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queue = mapped
    }

    /**
     * @param argument The encryption function of the queue storage service.
     */
    @JvmName("ktgewfaluuxngatt")
    public suspend fun queue(argument: suspend EncryptionServiceArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionServiceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.queue = mapped
    }

    /**
     * @param value The encryption function of the table storage service.
     */
    @JvmName("pxjuvgnxkivsqtql")
    public suspend fun table(`value`: EncryptionServiceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.table = mapped
    }

    /**
     * @param argument The encryption function of the table storage service.
     */
    @JvmName("jpvpvkcurvwrvweu")
    public suspend fun table(argument: suspend EncryptionServiceArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionServiceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.table = mapped
    }

    internal fun build(): EncryptionServicesArgs = EncryptionServicesArgs(
        blob = blob,
        `file` = `file`,
        queue = queue,
        table = table,
    )
}
