@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.GetBlobServicePropertiesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property blobServicesName The name of the blob Service within the specified storage account. Blob Service Name must be 'default'
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetBlobServicePropertiesPlainArgs(
    public val accountName: String,
    public val blobServicesName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.GetBlobServicePropertiesPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.GetBlobServicePropertiesPlainArgs =
        com.pulumi.azurenative.storage.inputs.GetBlobServicePropertiesPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .blobServicesName(blobServicesName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetBlobServicePropertiesPlainArgs].
 */
@PulumiTagMarker
public class GetBlobServicePropertiesPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var blobServicesName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("luninwlvnxmorthn")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the blob Service within the specified storage account. Blob Service Name must be 'default'
     */
    @JvmName("weadhtdfsmiineuu")
    public suspend fun blobServicesName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.blobServicesName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("jwatxefqintafoag")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetBlobServicePropertiesPlainArgs = GetBlobServicePropertiesPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        blobServicesName = blobServicesName ?: throw PulumiNullFieldException("blobServicesName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
