@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.GetFileSharePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property expand Optional, used to expand the properties within share's properties. Valid values are: stats. Should be passed as a string with delimiter ','.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 * @property shareName The name of the file share within the specified storage account. File share names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
 */
public data class GetFileSharePlainArgs(
    public val accountName: String,
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val shareName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.GetFileSharePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.GetFileSharePlainArgs =
        com.pulumi.azurenative.storage.inputs.GetFileSharePlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .shareName(shareName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFileSharePlainArgs].
 */
@PulumiTagMarker
public class GetFileSharePlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var shareName: String? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("mkkmmmusiwraosfe")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Optional, used to expand the properties within share's properties. Valid values are: stats. Should be passed as a string with delimiter ','.
     */
    @JvmName("fgyvkkmmgvjykupo")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("uxtsyqjyyygviwjg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the file share within the specified storage account. File share names must be between 3 and 63 characters in length and use numbers, lower-case letters and dash (-) only. Every dash (-) character must be immediately preceded and followed by a letter or number.
     */
    @JvmName("kdhytwcbcryqouva")
    public suspend fun shareName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.shareName = mapped
    }

    internal fun build(): GetFileSharePlainArgs = GetFileSharePlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        shareName = shareName ?: throw PulumiNullFieldException("shareName"),
    )
}
