@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.GetPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class GetPrivateEndpointConnectionPlainArgs(
    public val accountName: String,
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.GetPrivateEndpointConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.GetPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.storage.inputs.GetPrivateEndpointConnectionPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("eacdldkyixedaccs")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("owlnvqdhmhuebliw")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("xyobqlkqglsxapje")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionPlainArgs =
        GetPrivateEndpointConnectionPlainArgs(
            accountName = accountName ?: throw PulumiNullFieldException("accountName"),
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
