@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.IdentityArgs.builder
import com.pulumi.azurenative.storage.kotlin.enums.IdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Identity for the resource.
 * @property type The identity type.
 * @property userAssignedIdentities Gets or sets a list of key value pairs that describe the set of User Assigned identities that will be used with this storage account. The key is the ARM resource identifier of the identity. Only 1 User Assigned identity is permitted here.
 */
public data class IdentityArgs(
    public val type: Output<Either<String, IdentityType>>,
    public val userAssignedIdentities: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.IdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.IdentityArgs =
        com.pulumi.azurenative.storage.inputs.IdentityArgs.builder()
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentityArgs].
 */
@PulumiTagMarker
public class IdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, IdentityType>>? = null

    private var userAssignedIdentities: Output<List<String>>? = null

    /**
     * @param value The identity type.
     */
    @JvmName("kxjdcexrltwmbmky")
    public suspend fun type(`value`: Output<Either<String, IdentityType>>) {
        this.type = value
    }

    /**
     * @param value Gets or sets a list of key value pairs that describe the set of User Assigned identities that will be used with this storage account. The key is the ARM resource identifier of the identity. Only 1 User Assigned identity is permitted here.
     */
    @JvmName("dhxtnklwujtltwyd")
    public suspend fun userAssignedIdentities(`value`: Output<List<String>>) {
        this.userAssignedIdentities = value
    }

    @JvmName("adjoucfiotcqycnf")
    public suspend fun userAssignedIdentities(vararg values: Output<String>) {
        this.userAssignedIdentities = Output.all(values.asList())
    }

    /**
     * @param values Gets or sets a list of key value pairs that describe the set of User Assigned identities that will be used with this storage account. The key is the ARM resource identifier of the identity. Only 1 User Assigned identity is permitted here.
     */
    @JvmName("asaiajhxirumafgi")
    public suspend fun userAssignedIdentities(values: List<Output<String>>) {
        this.userAssignedIdentities = Output.all(values)
    }

    /**
     * @param value The identity type.
     */
    @JvmName("dkfqcmilvomoiayo")
    public suspend fun type(`value`: Either<String, IdentityType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The identity type.
     */
    @JvmName("lysyvtfhdpnntfdv")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The identity type.
     */
    @JvmName("odxvhvusxwbxcpyc")
    public fun type(`value`: IdentityType) {
        val toBeMapped = Either.ofRight<String, IdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Gets or sets a list of key value pairs that describe the set of User Assigned identities that will be used with this storage account. The key is the ARM resource identifier of the identity. Only 1 User Assigned identity is permitted here.
     */
    @JvmName("lbfumnqnnasuqxjl")
    public suspend fun userAssignedIdentities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values Gets or sets a list of key value pairs that describe the set of User Assigned identities that will be used with this storage account. The key is the ARM resource identifier of the identity. Only 1 User Assigned identity is permitted here.
     */
    @JvmName("oqgiupqwfmbjenhg")
    public suspend fun userAssignedIdentities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): IdentityArgs = IdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        userAssignedIdentities = userAssignedIdentities,
    )
}
