@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ImmutableStorageAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * This property enables and defines account-level immutability. Enabling the feature auto-enables Blob Versioning.
 * @property enabled A boolean flag which enables account-level immutability. All the containers under such an account have object-level immutability enabled by default.
 * @property immutabilityPolicy Specifies the default account-level immutability policy which is inherited and applied to objects that do not possess an explicit immutability policy at the object level. The object-level immutability policy has higher precedence than the container-level immutability policy, which has a higher precedence than the account-level immutability policy.
 */
public data class ImmutableStorageAccountArgs(
    public val enabled: Output<Boolean>? = null,
    public val immutabilityPolicy: Output<AccountImmutabilityPolicyPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ImmutableStorageAccountArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ImmutableStorageAccountArgs =
        com.pulumi.azurenative.storage.inputs.ImmutableStorageAccountArgs.builder()
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .immutabilityPolicy(
                immutabilityPolicy?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ImmutableStorageAccountArgs].
 */
@PulumiTagMarker
public class ImmutableStorageAccountArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var immutabilityPolicy: Output<AccountImmutabilityPolicyPropertiesArgs>? = null

    /**
     * @param value A boolean flag which enables account-level immutability. All the containers under such an account have object-level immutability enabled by default.
     */
    @JvmName("svwekgryrqtepkvg")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Specifies the default account-level immutability policy which is inherited and applied to objects that do not possess an explicit immutability policy at the object level. The object-level immutability policy has higher precedence than the container-level immutability policy, which has a higher precedence than the account-level immutability policy.
     */
    @JvmName("gxwadclwaconohmm")
    public suspend fun immutabilityPolicy(`value`: Output<AccountImmutabilityPolicyPropertiesArgs>) {
        this.immutabilityPolicy = value
    }

    /**
     * @param value A boolean flag which enables account-level immutability. All the containers under such an account have object-level immutability enabled by default.
     */
    @JvmName("ynyntlkboktqyqtr")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Specifies the default account-level immutability policy which is inherited and applied to objects that do not possess an explicit immutability policy at the object level. The object-level immutability policy has higher precedence than the container-level immutability policy, which has a higher precedence than the account-level immutability policy.
     */
    @JvmName("blfxejljcijkeooe")
    public suspend fun immutabilityPolicy(`value`: AccountImmutabilityPolicyPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.immutabilityPolicy = mapped
    }

    /**
     * @param argument Specifies the default account-level immutability policy which is inherited and applied to objects that do not possess an explicit immutability policy at the object level. The object-level immutability policy has higher precedence than the container-level immutability policy, which has a higher precedence than the account-level immutability policy.
     */
    @JvmName("muwvmtbwjmdltlhl")
    public suspend
    fun immutabilityPolicy(argument: suspend AccountImmutabilityPolicyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AccountImmutabilityPolicyPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.immutabilityPolicy = mapped
    }

    internal fun build(): ImmutableStorageAccountArgs = ImmutableStorageAccountArgs(
        enabled = enabled,
        immutabilityPolicy = immutabilityPolicy,
    )
}
