@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ListStorageAccountKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
 * @property expand Specifies type of the key to be listed. Possible value is kerb.
 * @property resourceGroupName The name of the resource group within the user's subscription. The name is case insensitive.
 */
public data class ListStorageAccountKeysPlainArgs(
    public val accountName: String,
    public val expand: String? = null,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ListStorageAccountKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ListStorageAccountKeysPlainArgs =
        com.pulumi.azurenative.storage.inputs.ListStorageAccountKeysPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListStorageAccountKeysPlainArgs].
 */
@PulumiTagMarker
public class ListStorageAccountKeysPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var expand: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the storage account within the specified resource group. Storage account names must be between 3 and 24 characters in length and use numbers and lower-case letters only.
     */
    @JvmName("qvvhgorsosvedcwk")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Specifies type of the key to be listed. Possible value is kerb.
     */
    @JvmName("xjtbgbysxrnlvqkp")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription. The name is case insensitive.
     */
    @JvmName("yqqqronpfhxankdf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListStorageAccountKeysPlainArgs = ListStorageAccountKeysPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
