@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.ProtocolSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Protocol settings for file service
 * @property smb Setting for SMB protocol
 */
public data class ProtocolSettingsArgs(
    public val smb: Output<SmbSettingArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.ProtocolSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.ProtocolSettingsArgs =
        com.pulumi.azurenative.storage.inputs.ProtocolSettingsArgs.builder()
            .smb(smb?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ProtocolSettingsArgs].
 */
@PulumiTagMarker
public class ProtocolSettingsArgsBuilder internal constructor() {
    private var smb: Output<SmbSettingArgs>? = null

    /**
     * @param value Setting for SMB protocol
     */
    @JvmName("xdaxfcpnylqpvhyn")
    public suspend fun smb(`value`: Output<SmbSettingArgs>) {
        this.smb = value
    }

    /**
     * @param value Setting for SMB protocol
     */
    @JvmName("vlmawspphwpjlmjv")
    public suspend fun smb(`value`: SmbSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smb = mapped
    }

    /**
     * @param argument Setting for SMB protocol
     */
    @JvmName("juwkttrnyiwvsoap")
    public suspend fun smb(argument: suspend SmbSettingArgsBuilder.() -> Unit) {
        val toBeMapped = SmbSettingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.smb = mapped
    }

    internal fun build(): ProtocolSettingsArgs = ProtocolSettingsArgs(
        smb = smb,
    )
}
