@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.inputs

import com.pulumi.azurenative.storage.inputs.SshPublicKeyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property description Optional. It is used to store the function/usage of the key
 * @property key Ssh public key base64 encoded. The format should be: '<keyType> <keyData>', e.g. ssh-rsa AAAABBBB
 */
public data class SshPublicKeyArgs(
    public val description: Output<String>? = null,
    public val key: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.storage.inputs.SshPublicKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.storage.inputs.SshPublicKeyArgs =
        com.pulumi.azurenative.storage.inputs.SshPublicKeyArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .key(key?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SshPublicKeyArgs].
 */
@PulumiTagMarker
public class SshPublicKeyArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var key: Output<String>? = null

    /**
     * @param value Optional. It is used to store the function/usage of the key
     */
    @JvmName("ktiwinbruvldnlyc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Ssh public key base64 encoded. The format should be: '<keyType> <keyData>', e.g. ssh-rsa AAAABBBB
     */
    @JvmName("gvwjudtndeoswpke")
    public suspend fun key(`value`: Output<String>) {
        this.key = value
    }

    /**
     * @param value Optional. It is used to store the function/usage of the key
     */
    @JvmName("vhqygfkpsjvcbnyp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Ssh public key base64 encoded. The format should be: '<keyType> <keyData>', e.g. ssh-rsa AAAABBBB
     */
    @JvmName("kvqftrhiduccoxlg")
    public suspend fun key(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.key = mapped
    }

    internal fun build(): SshPublicKeyArgs = SshPublicKeyArgs(
        description = description,
        key = key,
    )
}
