@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * An object that defines the blob inventory rule.
 * @property filters An object that defines the filter set.
 * @property format This is a required field, it specifies the format for the inventory files.
 * @property objectType This is a required field. This field specifies the scope of the inventory created either at the blob or container level.
 * @property schedule This is a required field. This field is used to schedule an inventory formation.
 * @property schemaFields This is a required field. This field specifies the fields and properties of the object to be included in the inventory. The Schema field value 'Name' is always required. The valid values for this field for the 'Blob' definition.objectType include 'Name, Creation-Time, Last-Modified, Content-Length, Content-MD5, BlobType, AccessTier, AccessTierChangeTime, AccessTierInferred, Tags, Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, Snapshot, VersionId, IsCurrentVersion, Metadata, LastAccessTime, Tags, Etag, ContentType, ContentEncoding, ContentLanguage, ContentCRC64, CacheControl, ContentDisposition, LeaseStatus, LeaseState, LeaseDuration, ServerEncrypted, Deleted, DeletionId, DeletedTime, RemainingRetentionDays, ImmutabilityPolicyUntilDate, ImmutabilityPolicyMode, LegalHold, CopyId, CopyStatus, CopySource, CopyProgress, CopyCompletionTime, CopyStatusDescription, CustomerProvidedKeySha256, RehydratePriority, ArchiveStatus, XmsBlobSequenceNumber, EncryptionScope, IncrementalCopy, TagCount'. For Blob object type schema field value 'DeletedTime' is applicable only for Hns enabled accounts. The valid values for 'Container' definition.objectType include 'Name, Last-Modified, Metadata, LeaseStatus, LeaseState, LeaseDuration, PublicAccess, HasImmutabilityPolicy, HasLegalHold, Etag, DefaultEncryptionScope, DenyEncryptionScopeOverride, ImmutableStorageWithVersioningEnabled, Deleted, Version, DeletedTime, RemainingRetentionDays'. Schema field values 'Expiry-Time, hdi_isfolder, Owner, Group, Permissions, Acl, DeletionId' are valid only for Hns enabled accounts.Schema field values 'Tags, TagCount' are only valid for Non-Hns accounts.
 */
public data class BlobInventoryPolicyDefinitionResponse(
    public val filters: BlobInventoryPolicyFilterResponse? = null,
    public val format: String,
    public val objectType: String,
    public val schedule: String,
    public val schemaFields: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.BlobInventoryPolicyDefinitionResponse):
            BlobInventoryPolicyDefinitionResponse = BlobInventoryPolicyDefinitionResponse(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.BlobInventoryPolicyFilterResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            format = javaType.format(),
            objectType = javaType.objectType(),
            schedule = javaType.schedule(),
            schemaFields = javaType.schemaFields().map({ args0 -> args0 }),
        )
    }
}
