@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The custom domain assigned to this storage account. This can be set via Update.
 * @property name Gets or sets the custom domain name assigned to the storage account. Name is the CNAME source.
 * @property useSubDomainName Indicates whether indirect CName validation is enabled. Default value is false. This should only be set on updates.
 */
public data class CustomDomainResponse(
    public val name: String,
    public val useSubDomainName: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.CustomDomainResponse):
            CustomDomainResponse = CustomDomainResponse(
            name = javaType.name(),
            useSubDomainName = javaType.useSubDomainName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
