@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The properties of a storage account’s Blob service.
 * @property automaticSnapshotPolicyEnabled Deprecated in favor of isVersioningEnabled property.
 * @property changeFeed The blob service properties for change feed events.
 * @property containerDeleteRetentionPolicy The blob service properties for container soft delete.
 * @property cors Specifies CORS rules for the Blob service. You can include up to five CorsRule elements in the request. If no CorsRule elements are included in the request body, all CORS rules will be deleted, and CORS will be disabled for the Blob service.
 * @property defaultServiceVersion DefaultServiceVersion indicates the default version to use for requests to the Blob service if an incoming request’s version is not specified. Possible values include version 2008-10-27 and all more recent versions.
 * @property deleteRetentionPolicy The blob service properties for blob soft delete.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isVersioningEnabled Versioning is enabled if set to true.
 * @property lastAccessTimeTrackingPolicy The blob service property to configure last access time based tracking policy.
 * @property name The name of the resource
 * @property restorePolicy The blob service properties for blob restore policy.
 * @property sku Sku name and tier.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetBlobServicePropertiesResult(
    public val automaticSnapshotPolicyEnabled: Boolean? = null,
    public val changeFeed: ChangeFeedResponse? = null,
    public val containerDeleteRetentionPolicy: DeleteRetentionPolicyResponse? = null,
    public val cors: CorsRulesResponse? = null,
    public val defaultServiceVersion: String? = null,
    public val deleteRetentionPolicy: DeleteRetentionPolicyResponse? = null,
    public val id: String,
    public val isVersioningEnabled: Boolean? = null,
    public val lastAccessTimeTrackingPolicy: LastAccessTimeTrackingPolicyResponse? = null,
    public val name: String,
    public val restorePolicy: RestorePolicyPropertiesResponse? = null,
    public val sku: SkuResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.GetBlobServicePropertiesResult):
            GetBlobServicePropertiesResult = GetBlobServicePropertiesResult(
            automaticSnapshotPolicyEnabled = javaType.automaticSnapshotPolicyEnabled().map({ args0 ->
                args0
            }).orElse(null),
            changeFeed = javaType.changeFeed().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ChangeFeedResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            containerDeleteRetentionPolicy = javaType.containerDeleteRetentionPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.DeleteRetentionPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            cors = javaType.cors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.CorsRulesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            defaultServiceVersion = javaType.defaultServiceVersion().map({ args0 -> args0 }).orElse(null),
            deleteRetentionPolicy = javaType.deleteRetentionPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.DeleteRetentionPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            isVersioningEnabled = javaType.isVersioningEnabled().map({ args0 -> args0 }).orElse(null),
            lastAccessTimeTrackingPolicy = javaType.lastAccessTimeTrackingPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.LastAccessTimeTrackingPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            restorePolicy = javaType.restorePolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.RestorePolicyPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.storage.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
