@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Properties of the file share, including Id, resource name, resource type, Etag.
 * @property accessTier Access tier for specific share. GpV2 account can choose between TransactionOptimized (default), Hot, and Cool. FileStorage account can choose Premium.
 * @property accessTierChangeTime Indicates the last modification time for share access tier.
 * @property accessTierStatus Indicates if there is a pending transition for access tier.
 * @property deleted Indicates whether the share was deleted.
 * @property deletedTime The deleted time if the share was deleted.
 * @property enabledProtocols The authentication protocol that is used for the file share. Can only be specified when creating a share.
 * @property etag Resource Etag.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property lastModifiedTime Returns the date and time the share was last modified.
 * @property leaseDuration Specifies whether the lease on a share is of infinite or fixed duration, only when the share is leased.
 * @property leaseState Lease state of the share.
 * @property leaseStatus The lease status of the share.
 * @property metadata A name-value pair to associate with the share as metadata.
 * @property name The name of the resource
 * @property remainingRetentionDays Remaining retention days for share that was soft deleted.
 * @property rootSquash The property is for NFS share only. The default is NoRootSquash.
 * @property shareQuota The maximum size of the share, in gigabytes. Must be greater than 0, and less than or equal to 5TB (5120). For Large File Shares, the maximum size is 102400.
 * @property shareUsageBytes The approximate size of the data stored on the share. Note that this value may not include all recently created or recently resized files.
 * @property signedIdentifiers List of stored access policies specified on the share.
 * @property snapshotTime Creation time of share snapshot returned in the response of list shares with expand param "snapshots".
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property version The version of the share.
 */
public data class GetFileShareResult(
    public val accessTier: String? = null,
    public val accessTierChangeTime: String,
    public val accessTierStatus: String,
    public val deleted: Boolean,
    public val deletedTime: String,
    public val enabledProtocols: String? = null,
    public val etag: String,
    public val id: String,
    public val lastModifiedTime: String,
    public val leaseDuration: String,
    public val leaseState: String,
    public val leaseStatus: String,
    public val metadata: Map<String, String>? = null,
    public val name: String,
    public val remainingRetentionDays: Int,
    public val rootSquash: String? = null,
    public val shareQuota: Int? = null,
    public val shareUsageBytes: Double,
    public val signedIdentifiers: List<SignedIdentifierResponse>? = null,
    public val snapshotTime: String,
    public val type: String,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.GetFileShareResult):
            GetFileShareResult = GetFileShareResult(
            accessTier = javaType.accessTier().map({ args0 -> args0 }).orElse(null),
            accessTierChangeTime = javaType.accessTierChangeTime(),
            accessTierStatus = javaType.accessTierStatus(),
            deleted = javaType.deleted(),
            deletedTime = javaType.deletedTime(),
            enabledProtocols = javaType.enabledProtocols().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            lastModifiedTime = javaType.lastModifiedTime(),
            leaseDuration = javaType.leaseDuration(),
            leaseState = javaType.leaseState(),
            leaseStatus = javaType.leaseStatus(),
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            name = javaType.name(),
            remainingRetentionDays = javaType.remainingRetentionDays(),
            rootSquash = javaType.rootSquash().map({ args0 -> args0 }).orElse(null),
            shareQuota = javaType.shareQuota().map({ args0 -> args0 }).orElse(null),
            shareUsageBytes = javaType.shareUsageBytes(),
            signedIdentifiers = javaType.signedIdentifiers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.SignedIdentifierResponse.Companion.toKotlin(args0)
                })
            }),
            snapshotTime = javaType.snapshotTime(),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
