@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.storage.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The replication policy between two storage accounts. Multiple rules can be defined in one policy.
 * @property destinationAccount Required. Destination account name. It should be full resource id if allowCrossTenantReplication set to false.
 * @property enabledTime Indicates when the policy is enabled on the source account.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property policyId A unique id for object replication policy.
 * @property rules The storage account object replication rules.
 * @property sourceAccount Required. Source account name. It should be full resource id if allowCrossTenantReplication set to false.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetObjectReplicationPolicyResult(
    public val destinationAccount: String,
    public val enabledTime: String,
    public val id: String,
    public val name: String,
    public val policyId: String,
    public val rules: List<ObjectReplicationPolicyRuleResponse>? = null,
    public val sourceAccount: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.storage.outputs.GetObjectReplicationPolicyResult):
            GetObjectReplicationPolicyResult = GetObjectReplicationPolicyResult(
            destinationAccount = javaType.destinationAccount(),
            enabledTime = javaType.enabledTime(),
            id = javaType.id(),
            name = javaType.name(),
            policyId = javaType.policyId(),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.storage.kotlin.outputs.ObjectReplicationPolicyRuleResponse.Companion.toKotlin(args0)
                })
            }),
            sourceAccount = javaType.sourceAccount(),
            type = javaType.type(),
        )
    }
}
